(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
            KFW_Mailchimp;

        KFW_Mailchimp = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main : '.kfw-ele-widget-mailchimp-main',
                    }
                }
            },

            getDefaultElements() {
                const { main } = this.getSettings( 'selectors' );

                return {
                    $main : this.$element.find( main ),
                    $buttonLoader : '<span class="kinfw-btn-dot-loader">'
                        + '<span class="kinfw-dot kinfw-dot-1"></span>'
                        + '<span class="kinfw-dot kinfw-dot-2"></span>'
                        + '<span class="kinfw-dot kinfw-dot-3"></span>'
                        + '</span>'
                }
            },

            bindEvents: function () {
                this._execute();
                this._noticeHandler();
            },

            _execute: function() {
                let $this   = this,
                    $id     = $this.getID(),
                    $main   = $this.elements.$main,
                    $loader = $this.elements.$buttonLoader;

                let $settings = $main.data('settings'),
                    $btn      = $('.kfw-ele-widget-mailchimp-button', $main ),
                    $form     = $('.kfw-ele-widget-mailchimp-form', $main ),
                    $email    = $('.kfw-ele-widget-mailchimp-email-field', $main ),
                    $name     = $('.kfw-ele-widget-mailchimp-name-field', $main ),
                    $notice   = $('.kinfw-notices-wrapper', $main );

                /**
                 * Email Field Focus
                 */
                    $email.focus(function(){
                        $(this).parent('.kfw-ele-widget-mailchimp-email-field-wrap').addClass('kfw-field-focus');
                    });

                    $email.focusout(function(){
                        $(this).parent('.kfw-ele-widget-mailchimp-email-field-wrap').removeClass('kfw-field-focus');
                    });

                /**
                 * Name Field Focus
                 */
                    if( $name.length ) {
                        $name.focus(function(){
                            $(this).parent('.kfw-ele-widget-mailchimp-name-field-wrap').addClass('kfw-field-focus');
                        });

                        $name.focusout(function(){
                            $(this).parent('.kfw-ele-widget-mailchimp-name-field-wrap').removeClass('kfw-field-focus');
                        });
                    }

                /**
                 * Form Submission
                 */
                    $( $form ).on( "submit", function( event ) {
                        /**
                         * Initial State
                         */
                            $action = false;
                            $error  = '';

                            $notice.removeClass('kinfw-hide-notice');
                            $notice.html('');

                        /**
                         * Email Field
                         */
                            let $emailVal      = $email.val(),
                                $validateEmail = $this._validateEmail( $emailVal );

                            if( $validateEmail ) {
                                $action = true;
                            } else {
                                $email.addClass('kfw-invalid');
                                $email.parent('.kfw-ele-widget-mailchimp-email-field-wrap').addClass('kfw-invalid');
                                $error = $settings['invalid-email'];
                            }

                        /**
                         * Name Field
                         */
                            if( $name.length ) {
                                let $nameVal      = $name.val(),
                                    $validateName = $this._validateName( $nameVal );

                                if( $validateName ) {
                                    $action = true;
                                } else {
                                    $name.addClass('kfw-invalid');
                                    $name.parent('.kfw-ele-widget-mailchimp-name-field-wrap').addClass('kfw-invalid');
                                    $error += '<br/>' + $settings['invalid-name'];
                                }
                            }

                        /**
                         * Error Handling
                         */
                            if( $error.length > 1 ) {
                                $notice.html( '<div class="kinfw-notice kinfw-failure-msg">' + $error + '</div>' );

                                setTimeout(function(){
                                    $notice.addClass('kinfw-hide-notice');

                                    /**
                                     * Email Field
                                     */
                                        $email.removeClass('kfw-invalid');
                                        $email.parent('.kfw-ele-widget-mailchimp-email-field-wrap').removeClass('kfw-invalid');

                                    /**
                                     * Name Field
                                     */
                                        if( $name.length ) {
                                            $name.removeClass('kfw-invalid');
                                            $name.parent('.kfw-ele-widget-mailchimp-name-field-wrap').removeClass('kfw-invalid');
                                        }
                                },2000);
                            }

                        /**
                         * Ajax
                         */
                            if( $action ) {

                                $formData = $form.serializeArray();

                                $formData.push({ 'name': 'akey', value: $settings.akey });
                                $formData.push({ 'name': 'aid', value: $settings.aid });
                                $formData.push({ 'name': 'success', value: $settings.message });

                                $.ajax({
                                    type      : 'POST',
                                    dataType  : 'json',
                                    url       : kfe_plugin_L10n.ajax,
                                    data      : $formData,
                                    beforeSend: function(){
                                        $btn.html( $loader );
                                    },
                                    success   : function ( $res ) {
                                        if( $res.success ) {
                                            if( $settings.redirect ) {
                                                window.location = $settings.redirectURL;
                                            } else {
                                                setTimeout(function(){
                                                    $notice.html( $res.data.message );
                                                    $btn.html( $settings.btn );
                                                },500);
                                            }
                                        } else {
                                            setTimeout(function(){
                                                $notice.html( $res.data.message );
                                                $btn.html( $settings.btn );
                                            },500);
                                        }
                                    }
                                });

                            }

                        event.preventDefault();
                    });
            },

            _validateEmail: function( $email ) {
                let $pattern = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
                return $pattern.test($email);
            },

            _validateName: function( $name ) {
                return ( '' === $name.trim() ) ? false : true;
            },

            _noticeHandler: function() {
                let $this = this,
                    $main = $this.elements.$main;

                let $notice = $('.kinfw-notices-wrapper', $main ),
                    $email  = $('.kfw-ele-widget-mailchimp-email-field', $main ),
                    $name   = $('.kfw-ele-widget-mailchimp-name-field', $main );

                $notice.on( "click", '.kinfw-notice', function() {
                    $notice.addClass( 'kinfw-hide-notice' );
                    $email.val('');
                    $name.val('');
                });
            },

        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-mailchimp', KFW_Mailchimp );
        elementorFrontend.elementsHandler.attachHandler( 'kfw-mailchimp-plus', KFW_Mailchimp );
    });
})( jQuery, window.elementorFrontend );