(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler       = elementorModules.frontend.handlers.Base,
        KFW_Testimonial_Large_Carousel;

        KFW_Testimonial_Large_Carousel = moduleHandler.extend({
            getDefaultSettings() {
                return {
                    selectors: {
                        main  : '.kfw-ele-widget-testimonial-large-carousel-main',
                        swiper: '.kfw-swiper',
                    }
                }
            },

            getDefaultElements() {
                const { main, swiper } = this.getSettings( 'selectors' );

                return {
                    $main  : this.$element.find( main ),
                    $swiper: this.$element.find( swiper ),
                }
            },

            bindEvents: function () {
                if( typeof( Swiper ) !== 'function' ) {
                    return;
                }

                let $isEdit = this.isEdit ? true : false;

                if( $isEdit ) {
                    this._copyToClipboard();
                }

                this._execute();
            },

            _copyToClipboard: function() {
                let $this = this,
                    $main = $this.elements.$main;

                let $clickable = $(".kfw-js-clickable", $main );

                $clickable.on("click",function(){
                    var $textToCopy = $(this).text().trim();

                    // Create a temporary input element
                    var tempInput = $('<input>');
                    $('body').append(tempInput);
                    tempInput.val($textToCopy).select();

                    // Execute copy command
                    document.execCommand('copy');

                    // Remove temporary input element
                    tempInput.remove();

                    alert($textToCopy + 'class copied' );
                });
            },

            _execute: function() {
                let $this       = this,
                    $id         = $this.getID(),
                    $main       = $this.elements.$main,
                    $swiper     = $this.elements.$swiper;

                let $settings = $main.data('settings'),
                    $items    = $(".kfw-testimonial-lg-item", $swiper);

                if( $items.length > 1 ) {
                    let $class  = $swiper.data("id"),
                        $len    = $class.length + 1,
                        $sclass = $class.padStart( $len, ".");

                    const Swiper = elementorFrontend.utils.swiper;
                    new Swiper( $($sclass),$settings);

                    if( $this._isBool( $settings.pauseOnHover ) === true ) {
                        $($sclass).hover(function () {
                            (this).swiper.autoplay.stop();
                        }, function () {
                            (this).swiper.autoplay.start();
                        });
                    }
                }
            },

            _isBool($arg ) {
                switch( $arg ) {
                    case true:
                    case "true":
                    case "TRUE":
                    case 1:
                    case "1":
                    case "on":
                    case "ON":
                    case "yes":
                    case "YES":
                    case "right":
                    case "RIGHT":
                        return true;

                    default:
                        return false;
                }
            },
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-testimonial-large-carousel', KFW_Testimonial_Large_Carousel );
    });
})( jQuery, window.elementorFrontend );