(function($, elementor ){
    $( window ).on( 'elementor/frontend/init', function(){
        let moduleHandler = elementorModules.frontend.handlers.Base,
        KFW_Txt_Highlighter;

        KFW_Txt_Highlighter = moduleHandler.extend({
            svgPaths : {
                circle          : ['M325,18C228.7-8.3,118.5,8.3,78,21C22.4,38.4,4.6,54.6,5.6,77.6c1.4,32.4,52.2,54,142.6,63.7 c66.2,7.1,212.2,7.5,273.5-8.3c64.4-16.6,104.3-57.6,33.8-98.2C386.7-4.9,179.4-1.4,126.3,20.7'],
                curly           : ['M3,146.1c17.1-8.8,33.5-17.8,51.4-17.8c15.6,0,17.1,18.1,30.2,18.1c22.9,0,36-18.6,53.9-18.6 c17.1,0,21.3,18.5,37.5,18.5c21.3,0,31.8-18.6,49-18.6c22.1,0,18.8,18.8,36.8,18.8c18.8,0,37.5-18.6,49-18.6c20.4,0,17.1,19,36.8,19 c22.9,0,36.8-20.6,54.7-18.6c17.7,1.4,7.1,19.5,33.5,18.8c17.1,0,47.2-6.5,61.1-15.6'],
                underline       : ['M7.7,145.6C109,125,299.9,116.2,401,121.3c42.1,2.2,87.6,11.8,87.3,25.7'],
                double          : ['M8.4,143.1c14.2-8,97.6-8.8,200.6-9.2c122.3-0.4,287.5,7.2,287.5,7.2', 'M8,19.4c72.3-5.3,162-7.8,216-7.8c54,0,136.2,0,267,7.8'],
                double_underline: ['M5,125.4c30.5-3.8,137.9-7.6,177.3-7.6c117.2,0,252.2,4.7,312.7,7.6', 'M26.9,143.8c55.1-6.1,126-6.3,162.2-6.1c46.5,0.2,203.9,3.2,268.9,6.4'],
                underline_zigzag: ['M9.3,127.3c49.3-3,150.7-7.6,199.7-7.4c121.9,0.4,189.9,0.4,282.3,7.2C380.1,129.6,181.2,130.6,70,139 c82.6-2.9,254.2-1,335.9,1.3c-56,1.4-137.2-0.3-197.1,9'],
            },

            getDefaultSettings() {
                settings = {
                    animDuration: this.getElementSettings('anim_duration') || 1200,
                    animDelay   : this.getElementSettings('anim_delay') || 1200,
                };

                settings.classes   = {
                    activateHighlight: 'e-animated',
                    hideHighlight: 'e-hide-highlight',
                };

                settings.selectors = {
                    main                : '.kfw-ele-widget-text-highlighter-main',
                    highliehterTitleWrap: '.kfw-ele-widget-text-highlighter-title-wrap',
                    highliehterWrap     : '.kfw-elementor-text-highlighter-wrap',
                    highliehterTxt      : '.kfw-elementor-text-highlighter-text',
                };

                return settings;
            },

            getDefaultElements() {
                let selectors = this.getSettings('selectors');

                return {
                    $main                : this.$element.find( selectors.main ),
                    $highliehterTitleWrap: this.$element.find( selectors.highliehterTitleWrap ),
                    $highliehterWrap     : this.$element.find( selectors.highliehterWrap ),
                    $highliehterTxt      : this.$element.find( selectors.highliehterTxt ),
                }
            },

            bindEvents: function () {
                let $this   = this;

                $this.intersectionObservers = {
                    startAnimation: {
                        observer: null,
                        element: null
                    }
                };

                $this._execute();
            },

            _execute() {
                let $this   = this;
                this.isLoopMode = 'yes' === this.getElementSettings('loop');

                if( $this.elements.$highliehterWrap.length ) {

                    $this.intersectionObservers.startAnimation.observer = elementorModules.utils.Scroll.scrollObserver({
                        offset  : `0px 0px -100px`,
                        callback: ( event ) => {
                            if ( event.isInViewport ) {
                                $this._initAnimation();
                            }
                        },
                    });

                    this.intersectionObservers.startAnimation.element = this.elements.$highliehterWrap[0];
                    this.intersectionObservers.startAnimation.observer.observe(this.intersectionObservers.startAnimation.element);
                }
            },

            _initAnimation() {
                let $this   = this;
                $this._addSVG();
                $this._activateHighlightAnimation();

                $this._deactivateHighlightAnimation();
            },

            _addSVG() {
                const $elementSettings = this.getElementSettings();
                $svg = jQuery('<svg>', {
                    xmlns: 'http://www.w3.org/2000/svg',
                    viewBox: '0 0 500 150',
                    preserveAspectRatio: 'none'
                }).html(this._getSvgPaths($elementSettings.highlight_type ));

                this.elements.$highliehterWrap.append($svg[0].outerHTML);
            },

            _getSvgPaths(pathName) {
                var pathsInfo = this.svgPaths[pathName],

                $paths = jQuery();
                pathsInfo.forEach(function (pathInfo) {
                    $paths = $paths.add(jQuery('<path>', {
                        d: pathInfo
                    }));
                });

                return $paths;
            },

            _activateHighlightAnimation() {
                const settings              = this.getSettings(),
                      classes               = settings.classes,
                      $highliehterTitleWrap = this.elements.$highliehterTitleWrap;

                $highliehterTitleWrap.removeClass(classes.hideHighlight).addClass(classes.activateHighlight);

                if (!this.isLoopMode) {
                    return;
                }

                setTimeout(() => {
                    $highliehterTitleWrap.removeClass(classes.activateHighligh).addClass(classes.hideHighlight);
                }, settings.animDuration + settings.animDelay * .8);

                setTimeout(() => {
                    this._activateHighlightAnimation(false);
                }, settings.animDuration + settings.animDelay);
            },

            _deactivateHighlightAnimation() {
                this.intersectionObservers.startAnimation.observer.unobserve(this.intersectionObservers.startAnimation.element);
            }
        });

        elementorFrontend.elementsHandler.attachHandler( 'kfw-text-highlighter', KFW_Txt_Highlighter );
    });
})( jQuery, window.elementorFrontend );