<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor' ) ) {

	/**
	 * Define the elementor plugin compatibility.
	 */
    class KinForce_Extra_Plugin_Elementor {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            $this->load_dependencies();
			$this->load_modules();

            do_action( 'kinfw-action/plugin/elementor/loaded' );

        }

		/**
		 * Load the required dependencies for this plugin.
		 */
		private function load_dependencies() {

            if( !$this->check_requirement() ) {

                return;
            }
        }

        /**
         * Load the required dependencies for elementor.
         */
		public function load_modules() {

			if( !is_plugin_active( 'elementor/elementor.php' ) ) {
				return;
			}

            $this->init_settings();

			/**
			 * Elementor Assets Manager
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-assets-manager.php';

			/**
			 * Elementor Controls Manager
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-controls-manager.php';

			/**
			 * Elementor Extensions Manager
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-extensions-manager.php';

			/**
			 * Elementor Modules Manager
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-modules-manager.php';

			/**
			 * Custom Post Type
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-single-blog-post-modules-manager.php';
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-single-team-member-modules-manager.php';
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-single-project-modules-manager.php';

			/**
			 * Image Reveal Effect
			 */
			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-effect-image-reveal.php';

			require_once KFE_CONST_DIR . 'libraries/elementor/classes/class-modules-wp-ajax-manager.php';

		}

		public function init_settings() {

            add_action( 'kinfw-action/theme/site-options/custom-css/loaded', function() {

				CSF::createSection( ONNAT_CONST_THEME_OPTION_PREFIX, [
					'id'    => 'theme_elementor_section',
					'title' => esc_html__( 'Elementor', 'onnat-extra' ),
				] );

				do_action( 'kinfw-action/theme/site-options/elementor/loaded' );

			}, 100 );

		}

		/**
		 * Returns path to template file.
		 */
		public function get_template( $name = null ) {

			$template_path = apply_filters( 'kinfw-filter/plugin/elementor/widgets/template-path', 'kfw-elementor-widgets-templates/' );
			$template      = locate_template( $template_path . $name . '.php' );

			if ( !$template ) {
				$template = KFE_CONST_DIR . 'libraries/elementor/templates/' . $name . '.php';
			}

			if ( file_exists( $template ) ) {
                return $template;
			} else {
				return false;
			}

		}

		/**
	 	 * Widget utility function
	 	 * Returns Elementor library list
	 	 */
		public function get_elementor_library() {

			$templates = get_posts([
				'post_type'      => 'elementor_library',
				'posts_per_page' => -1
			]);

			$result = [ esc_html__( '-- Select --', 'onnat-extra' ) ];

			if ( ! empty( $templates ) && ! is_wp_error( $templates ) ) {
				foreach ( $templates as $item ) {
					$result[ $item->ID ] = $item->post_title;
				}
			}

			return $result;

		}

		/**
		 * Widget utility function
		 * Returns Currency Symbol
		 */
		public function get_currency_symbol($symbol_name) {
			$symbols = [
				'dollar'       => '&#36;',
				'baht'         => '&#3647;',
				'euro'         => '&#128;',
				'franc'        => '&#8355;',
				'guilder'      => '&fnof;',
				'indian_rupee' => '&#8377;',
				'krona'        => 'kr',
				'lira'         => '&#8356;',
				'peseta'       => '&#8359',
				'peso'         => '&#8369;',
				'pound'        => '&#163;',
				'real'         => 'R$',
				'ruble'        => '&#8381;',
				'rupee'        => '&#8360;',
				'bdt'          => '&#2547;',
				'shekel'       => '&#8362;',
				'won'          => '&#8361;',
				'yen'          => '&#165;',
			];
			return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
		}

		/**
		 * Widget utility function
		 * Returns available nav menus
		 */
		public function get_available_menus() {

			$result = [ esc_html__( '-- Select --', 'onnat-extra' ) ];
			$menus  = wp_get_nav_menus();

			foreach ($menus as $menu) {
				$result[ $menu->slug ] = $menu->name;
			}

			return $result;
		}

		/**
		 * Check whether basic provision reached.
		 */
		private function check_requirement() {

            require_once( ABSPATH . 'wp-admin/includes/plugin.php' );

            if( !is_plugin_active( 'elementor/elementor.php' ) ) {

                if ( isset( $_GET['activate'] ) ) {
                    unset( $_GET['activate'] );
                }

                add_action( 'admin_notices', function() {

                    /* translators: %s: html tags */
                    $message = sprintf(
                        __( 'The %1$s Onnat Extra %2$s plugin is compatible with %1$sElementor%2$s plugin. Kindly install and activate it.', 'onnat-extra' ),
                        '<strong>',
                        '</strong>'
                    );

                    if( $this->is_elementor_installed() && current_user_can( 'activate_plugins' ) ) {

						$button = sprintf( '<a href="%1$s" class="button-primary">%2$s</a>',
                            wp_nonce_url( admin_url(
                                add_query_arg( [
									'action'        => 'activate',
									'plugin'        => 'elementor/elementor.php',
									'plugin_status' => 'all',
									'paged'         => '1' ],
									'plugins.php'
								) ),
								'activate-plugin_elementor/elementor.php'
							),
							esc_html__( 'Activate Elementor', 'onnat-extra' )
						);

					} else if( !$this->is_elementor_installed() && current_user_can( 'install_plugins' ) ) {

						$button = sprintf( '<a href="%1$s" class="button-primary">%2$s</a>',
							wp_nonce_url( self_admin_url(
								add_query_arg( [
									'action' => 'install-plugin',
									'plugin' => 'elementor' ],
									'update.php'
								) ),
								'install-plugin_elementor'
							),
							esc_html__( 'Install Elementor', 'onnat-extra' )
                        );

                    }

                    printf( '<div class="notice notice-info is-dismissible"> <p> %1$s </p> <p> %2$s </p> </div>', $message, $button );

                } );

                return false;
            }

            return true;
        }

		/**
		 * Check whether Elementor plugin installed.
		 */
		private function is_elementor_installed() {
			$plugins = get_plugins();

            return isset( $plugins['elementor/elementor.php'] );
        }

		public function get_latest_post_id( $post_type = 'post' ) {
			$recent_posts = wp_get_recent_posts([
				'numberposts' => 1,
				'post_type'   => $post_type,
				'post_status' => 'publish',
				'orderby'     => 'date',
				'order'       => 'DESC',
			]);

			if (!empty($recent_posts)) {
				return $recent_posts[0]['ID'];
			} else {
				return 0; // Return 0 if no posts found
			}
		}
    }
}

if( !function_exists( 'kf_extra_plugin_elementor' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor() {

        return KinForce_Extra_Plugin_Elementor::get_instance();
    }
}

kf_extra_plugin_elementor();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */