<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Team_Member_Elementor_Modules_Manager' ) ) {

	/**
	 * Elementor modules setup class.
	 */
    class KinForce_Extra_Plugin_CPT_Team_Member_Elementor_Modules_Manager {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

			add_action( 'elementor/elements/categories_registered', [ $this, 'register_category' ], 50 );
			add_action( 'elementor/widgets/register', [ $this, 'register_widget' ], 50 );
        }

        /**
         * Add elementor widget category
         */
        public function register_category( $elements_manager  ) {

			$categories     = [];
			$old_categories = $elements_manager->get_categories();

			if( is_singular('kinfw-team-member') || is_singular('elementor_library') ) {

				$categories['_kfw_single_team_member_widgets'] = [
					'title' => esc_html__( 'KinForce - Single Team Member', 'onnat-extra' ),
					'icon'  => 'eicon-font',
				];
			}

			$categories     = array_merge($categories, $old_categories);
            $set_categories = function ( $categories ) {
                $this->categories = $categories;
			};

			$set_categories->call( $elements_manager, $categories );
		}

        public function register_widget( $widgets_manager ) {

            /**
             * Featured Image
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-team-member-featured-image.php';
            $widgets_manager->register( new KFW_CPT_Team_Member_Featured_Image() );

            /**
             * Social Links
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-team-member-social-links.php';
            $widgets_manager->register( new KFW_CPT_Team_Member_Social_Links() );

            /**
             * Meta
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-team-member-meta.php';
            $widgets_manager->register( new KFW_CPT_Team_Member_Meta() );

            /**
             * Taxonomy
             */
            require_once KFE_CONST_DIR . 'libraries/elementor/widgets/kfw-cpt-team-member-taxonomy.php';
            $widgets_manager->register( new KFW_CPT_Team_Member_Taxonomy() );

        }

    }

}

if( !function_exists( 'kf_extra_plugin_cpt_team_member_elementor_modules_manager' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_team_member_elementor_modules_manager() {

        return KinForce_Extra_Plugin_CPT_Team_Member_Elementor_Modules_Manager::get_instance();
    }
}

kf_extra_plugin_cpt_team_member_elementor_modules_manager();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */