<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_CSS_Pseudo' ) ) {

	/**
	 * Elementor Extension: CSS Pseudo setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_CSS_Pseudo {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/css-pseudo/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/css-pseudo', $this->active );

            if( $this->active ) {

				add_action('elementor/element/container/section_layout/after_section_end', [ $this, 'register_section' ], 10, 2 );
				add_action('elementor/element/section/section_advanced/after_section_end', [ $this, 'register_section' ], 10, 2 );
				add_action('elementor/element/column/section_advanced/after_section_end', [ $this, 'register_section' ], 10, 2 );
				add_action('elementor/element/common/kfw_section_custom_css/after_section_end', [ $this, 'register_section' ], 10, 2 );

			}

		}

        public function register_section( $element, $section_id ) {
            $ele_name = $element->get_name();
            $name     = str_replace( ' ', '', ucwords( str_replace( '-', ' ', $ele_name ) ) );

            switch ( $ele_name ) {
                case 'container':
                case 'section':
                case 'column':
                break;

                default:
                    $name = esc_html__( 'Widget', 'onnat-extra' );
                break;
            }

            $this->_register_css_pseudo_after_section( $element, $name );
            $this->_register_css_pseudo_before_section( $element, $name );

        }

        public function _register_css_pseudo_after_section( $controls_stack, $name ) {

            $controls_stack->start_controls_section( 'kfw_section_css_pseudo_after', [
                'label' => esc_html__( 'CSS Pseudo Element ( ::after )', 'onnat-extra' ),
                'tab'   => Elementor\Controls_Manager::TAB_ADVANCED
            ] );

                $controls_stack->add_control( 'kfw_section_css_pseudo_after_desc', [
                    'raw'             => sprintf( __( 'The ::after selector inserts something after the content of each %s', 'onnat-extra'), $name ),
                    'type'            => Elementor\Controls_Manager::RAW_HTML,
                    'content_classes' => 'elementor-descriptor',
                ] );

                $controls_stack->add_group_control( Elementor\Group_Control_Background::get_type(), [
                    'name'           => 'background_pseudo_after',
                    'types'          => [ 'classic', 'gradient' ],
                    'selector'       => '{{WRAPPER}}:after',
                    'fields_options' => [
                        'background' => [
                            'frontend_available' => true,
                        ]
                    ]
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_after_z_idx', [
                    'label'     => esc_html__( 'Z-Index', 'onnat-extra' ),
                    'type'      => Elementor\Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}}:after' => 'z-index: {{VALUE}};',
                    ],
                    'condition' => [
                        'background_pseudo_after_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_after_pos', [
                    'label'      => esc_html__( 'Position', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}}:after' => 'content:"";position:absolute;top:{{TOP}}{{UNIT}};right:{{RIGHT}}{{UNIT}};bottom:{{BOTTOM}}{{UNIT}};left:{{LEFT}}{{UNIT}};',
                    ],
                    'condition'  => [
                        'background_pseudo_after_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_after_width', [
                    'label'      => esc_html__( 'Width', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        '%'  => [
                            'min' => 10,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}}:after' => 'width:{{SIZE}}{{UNIT}};'
                    ],
                    'condition'  => [
                        'background_pseudo_after_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_after_height', [
                    'label'      => esc_html__( 'Height', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        '%'  => [
                            'min' => 10,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}}:after' => 'height:{{SIZE}}{{UNIT}};'
                    ],
                    'condition'  => [
                        'background_pseudo_after_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

            $controls_stack->end_controls_section();

        }

        public function _register_css_pseudo_before_section( $controls_stack, $name ) {

            $controls_stack->start_controls_section( 'kfw_section_css_pseudo_before', [
                'label' => esc_html__( 'CSS Pseudo Element ( ::before )', 'onnat-extra' ),
                'tab'   => Elementor\Controls_Manager::TAB_ADVANCED
            ] );

                $controls_stack->add_control( 'kfw_section_css_pseudo_before_desc', [
                    'raw'             => sprintf( __( 'The ::before selector inserts something before the content of each %s', 'onnat-extra'), $name ),
                    'type'            => Elementor\Controls_Manager::RAW_HTML,
                    'content_classes' => 'elementor-descriptor',
                ] );

                $controls_stack->add_group_control( Elementor\Group_Control_Background::get_type(), [
                    'name'           => 'background_pseudo_before',
                    'types'          => [ 'classic', 'gradient' ],
                    'selector'       => '{{WRAPPER}}:before',
                    'fields_options' => [
                        'background' => [
                            'frontend_available' => true,
                        ]
                    ]
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_before_z_idx', [
                    'label'     => esc_html__( 'Z-Index', 'onnat-extra' ),
                    'type'      => Elementor\Controls_Manager::NUMBER,
                    'selectors' => [
                        '{{WRAPPER}}:before' => 'z-index: {{VALUE}};',
                    ],
                    'condition' => [
                        'background_pseudo_before_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_before_pos', [
                    'label'      => esc_html__( 'Position', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::DIMENSIONS,
                    'size_units' => [ 'px', '%' ],
                    'selectors'  => [
                        '{{WRAPPER}}:before' => 'content:"";position:absolute;top:{{TOP}}{{UNIT}};right:{{RIGHT}}{{UNIT}};bottom:{{BOTTOM}}{{UNIT}};left:{{LEFT}}{{UNIT}};',
                    ],
                    'condition'  => [
                        'background_pseudo_before_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_before_width', [
                    'label'      => esc_html__( 'Width', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        '%'  => [
                            'min' => 10,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}}:before' => 'width:{{SIZE}}{{UNIT}};'
                    ],
                    'condition'  => [
                        'background_pseudo_before_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

                $controls_stack->add_responsive_control( 'bg_pseudo_before_height', [
                    'label'      => esc_html__( 'Height', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [ 'px', '%' ],
                    'range'      => [
                        '%'  => [
                            'min' => 10,
                            'max' => 100,
                        ],
                        'px' => [
                            'min' => 0,
                            'max' => 1000,
                        ],
                    ],
                    'selectors'  => [
                        '{{WRAPPER}}:before' => 'height:{{SIZE}}{{UNIT}};'
                    ],
                    'condition'  => [
                        'background_pseudo_before_background' => [ 'classic', 'gradient' ],
                    ],
                ] );

            $controls_stack->end_controls_section();

        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_css_pseudo' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_css_pseudo() {

        return KinForce_Extra_Plugin_Elementor_Extension_CSS_Pseudo::get_instance();
    }
}

kf_extra_plugin_elementor_extension_css_pseudo();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */