<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Custom_Cursor' ) ) {

	/**
	 * Elementor Extension: Custom Cursor setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Custom_Cursor {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/wrapper-link/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/custom-cursor', $this->active );

            if( $this->active ) {
                add_action('elementor/element/container/section_layout/before_section_start', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/section/section_structure/after_section_end', [ $this, 'register_section' ], 10, 2 );
				add_action('elementor/element/column/section_advanced/after_section_end', [ $this, 'register_section' ], 10, 2 );
            }

        }

        public function register_section( $element, $section_id ) {
            $ele_name = $element->get_name();
            $name     = str_replace( ' ', '', ucwords( str_replace( '-', ' ', $ele_name ) ) );
            $tab      = Elementor\Controls_Manager::TAB_CONTENT;

            switch ( $ele_name ) {
                case 'container':
                case 'section':
                case 'column':
                    $tab = Elementor\Controls_Manager::TAB_LAYOUT;
                break;

                default:
                    $name = esc_html__( 'Widget', 'onnat-extra' );
                    $tab  = Elementor\Controls_Manager::TAB_CONTENT;
                break;
            }

            $this->_register_wrapper_custom_cursor_section( $element, $name, $tab );
        }

        public function _register_wrapper_custom_cursor_section( $controls_stack, $name, $tab ) {

            $controls_stack->start_controls_section( 'kfw_section_wrapper_custom_cursor', [
                'label' => sprintf( __( '%s : Custom Cursor', 'onnat-extra'), $name ),
                'tab'   => $tab
            ] );

                $controls_stack->add_control( 'enable_kfw_cursor', [
                    'label'              => esc_html__( 'Enable Cursor Effect', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'           => esc_html__( 'Yes', 'onnat-extra' ),
                    'label_off'          => esc_html__( 'No', 'onnat-extra' ),
                    'frontend_available' => true,
                    'return_value'       => 'yes',
                    'default'            => 'no',
                ] );

                $controls_stack->add_control( 'kfw_cursor_opaque', [
                    'label'              => esc_html__( 'Opaque Effect', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'           => esc_html__( 'Yes', 'onnat-extra' ),
                    'label_off'          => esc_html__( 'No', 'onnat-extra' ),
                    'frontend_available' => true,
                    'return_value'       => 'yes',
                    'default'            => 'no',
                    'condition'          => [
                        'enable_kfw_cursor' => 'yes',
                    ]
                ] );

                /**
                 * Cursor Colors
                 */
                    $cursor_colors_opt = [
                        'kinfw-cursor-accent-color'    => esc_html__( 'Accent Color','onnat-extra' ),
                        'kinfw-cursor-secondary-color' => esc_html__( 'Secondary Color','onnat-extra' ),
                    ];

                    $cursor_colors = kinfw_onnat_theme_options()->kinfw_get_option( 'cursor_colors' );
                    foreach( $cursor_colors as $key => $cursor_color ) {
                        $cursor_colors_opt['kinfw-cursor-custom-'.$key.'-color'] = $cursor_color['label'];
                    }

                $controls_stack->add_control( 'kfw_cursor_color', [
                    'label'              => esc_html__( 'Color', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::SELECT,
                    'frontend_available' => true,
                    'options'            => $cursor_colors_opt,
                    'default'            => kinfw_onnat_theme_options()->kinfw_get_option( 'cursor_color' ),
                    'condition'          => [
                        'enable_kfw_cursor'  => 'yes',
                        'kfw_cursor_opaque!' => 'yes'
                    ]
                ] );
                $controls_stack->add_control( 'kfw_cursor_size', [
                    'label'              => esc_html__( 'Size', 'onnat-extra' ),
                    'type'               => \Elementor\Controls_Manager::CHOOSE,
                    'toggle'             => false,
                    'default'            => 'kinfw-cursor-sm-size',
                    'options'            => [
                        'kinfw-cursor-sm-size' => [
                            'title' => esc_html__( 'Small', 'onnat-extra' ),
                            'icon'  => 'kfw-ctrl-icon kfw-ctrl-sm-size',
                        ],
                        'kinfw-cursor-md-size' => [
                            'title' => esc_html__( 'Medium', 'onnat-extra' ),
                            'icon'  => 'kfw-ctrl-icon kfw-ctrl-md-size',
                        ],
                        'kinfw-cursor-lg-size' => [
                            'title' => esc_html__( 'Large', 'onnat-extra' ),
                            'icon'  => 'kfw-ctrl-icon kfw-ctrl-lg-size',
                        ],
                        'kinfw-cursor-xl-size' => [
                            'title' => esc_html__( 'Extra Large', 'onnat-extra' ),
                            'icon'  => 'kfw-ctrl-icon kfw-ctrl-xl-size',
                        ],
                    ],
                    'frontend_available' => true,
                    'condition'          => [
                        'enable_kfw_cursor' => 'yes',
                    ]
                ] );
            $controls_stack->end_controls_section();
        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_custom_cursor' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_custom_cursor() {

        return KinForce_Extra_Plugin_Elementor_Extension_Custom_Cursor::get_instance();
    }
}

kf_extra_plugin_elementor_extension_custom_cursor();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */