<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Custom_CSS' ) ) {

	/**
	 * Elementor Extension: Custom CSS setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Custom_CSS {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );


            do_action( 'kinfw-action/plugin/elementor/extensions/custom-css/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/custom-css', $this->active );

            if( $this->active ) {

				add_action( 'elementor/element/after_section_end', [ $this, 'register_controls' ], 10, 2 );
				add_filter( 'localize_settings/editor/localize_settings', [ $this, 'localize_settings' ] );

				add_action( 'elementor/element/parse_css', [ $this, 'add_post_css' ], 10, 2 );
				add_action( 'elementor/css-file/post/parse', [ $this, 'add_page_css' ] );

			}

		}

        /**
         * @param $element    Controls_Stack
         * @param $section_id string
         */
        public function register_controls( $element, $section_id ) {

            // Remove Custom CSS Banner from free version
            if ( 'section_custom_css_pro' !== $section_id ) {

                return;
            }

            $this->replace_go_pro_custom_css_section_controls( $element );

        }

		public function replace_go_pro_custom_css_section_controls( $controls_stack ) {

            $elementor_instance = \Elementor\Plugin::instance();

            $controls_to_remove = [
                'section_custom_css_pro',
                'custom_css_pro'
            ];

            $old_section = $elementor_instance
                ->controls_manager
                ->get_control_from_stack( $controls_stack->get_unique_name(), 'section_custom_css_pro' );

            $elementor_instance
                ->controls_manager
                ->remove_control_from_stack( $controls_stack->get_unique_name(), $controls_to_remove );

            $this->_register_custom_css_section( $controls_stack, $old_section['tab'] );

		}

		public function _register_custom_css_section( $controls_stack, $tab ) {

            $controls_stack->start_controls_section( 'kfw_section_custom_css', [
                'label' => esc_html__( 'Custom CSS', 'onnat-extra' ),
                'tab'   => $tab
            ] );

			$controls_stack->add_control( 'custom_css_title', [
				'raw'  => esc_html__( 'Add your own custom CSS here', 'onnat-extra' ),
				'type' => \Elementor\Controls_Manager::RAW_HTML,
			] );

				$controls_stack->add_control( 'custom_css', [
					'type'        => \Elementor\Controls_Manager::CODE,
					'label'       => esc_html__( 'Custom CSS', 'onnat-extra' ),
					'language'    => 'css',
					'render_type' => 'ui',
					'show_label'  => false,
					'separator'   => 'none',
				] );

			$controls_stack->add_control( 'custom_css_description', [
				'raw'             => wp_kses_post(
					__( 'Use "selector" to target wrapper element. Examples:<br>selector {color: green;} // For main element<br>selector .child-element {margin: 15px;} // For child element<br>.my-class {text-align: right;} // Or use any custom selector', 'onnat-extra' )
				),
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'content_classes' => 'elementor-descriptor',
			] );


			$controls_stack->end_controls_section();

		}

        public function localize_settings( array $settings ) {

            $settings['i18n']['custom_css'] = esc_html__( 'Custom CSS', 'onnat-extra' );

            return $settings;
        }

		public function add_post_css( $post_css, $element ) {

            $element_settings = $element->get_settings();

            if ( empty( $element_settings['custom_css'] ) ) {
                return;
            }

            $css = trim( $element_settings['custom_css'] );

            if ( empty( $css ) ) {
                return;
            }
            $css = str_replace( 'selector', $post_css->get_element_unique_selector( $element ), $css );

            // Add a css comment
            $css = sprintf( '/* Start custom CSS for %s, class: %s */', $element->get_name(), $element->get_unique_selector() ) . $css . '/* End custom CSS */';

            $post_css->get_stylesheet()->add_raw_css( $css );

		}

		public function add_page_css( $post_css ) {

            $document = \Elementor\Plugin::instance()->documents->get( $post_css->get_post_id() );
            $custom_css = $document->get_settings( 'custom_css' );

            if( is_null( $custom_css ) ) {
                return;
            }

            $custom_css = trim( $custom_css );

            if ( empty( $custom_css ) ) {
                return;
            }

            $custom_css = str_replace( 'selector', 'body.elementor-page-' . $post_css->get_post_id(), $custom_css );

            // Add a css comment
            $custom_css = '/* Start custom CSS for page-settings */' . $custom_css . '/* End custom CSS */';

            $post_css->get_stylesheet()->add_raw_css( $custom_css );

		}

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_custom_css' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_custom_css() {

        return KinForce_Extra_Plugin_Elementor_Extension_Custom_CSS::get_instance();
    }
}

kf_extra_plugin_elementor_extension_custom_css();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */