<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_GSAP_Scroll_Smoother' ) ) {

	/**
	 * Elementor Extension: GSAP Scroll Smoother setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_GSAP_Scroll_Smoother {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/gsap-scroll-smoother/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/gsap-scroll-smoother', $this->active );

            if( $this->active ) {

                add_action('elementor/element/container/section_layout/before_section_start', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/common/_section_style/after_section_end', [ $this, 'register_section' ], 10, 2 );

                add_action( 'elementor/frontend/before_render', [ $this, 'add_attributes' ] );
                
            }

        }

        public function register_section( $element, $section_id ) {

            $ele_name = $element->get_name();
            $name     = str_replace( ' ', '', ucwords( str_replace( '-', ' ', $ele_name ) ) );

            $tab = Elementor\Controls_Manager::TAB_CONTENT;

            switch ( $ele_name ) {
                case 'container':
                case 'section':
                case 'column':
                    $tab = Elementor\Controls_Manager::TAB_LAYOUT;
                break;

                default:
                    $name = esc_html__( 'Widget', 'onnat-extra' );
                    $tab  = Elementor\Controls_Manager::TAB_CONTENT;
                break;
            }

            $this->_register_section( $element, $name, $tab );

        }

        public function _register_section( $controls_stack, $name, $tab ) {
            $controls_stack->start_controls_section( 'kfw_section_gsap_scroll_smoother', [
                'label' => sprintf( __( '%s Scroll Smoother', 'onnat-extra'), $name ),
                'tab'   => $tab
            ] );

                $controls_stack->add_control( 'ext_gsap_scrollsmoother', [
                    'label'        => esc_html__( 'Enable It', 'onnat-extra' ),
                    'type'         => Elementor\Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                ]);
                $controls_stack->add_control( 'ext_gsap_scrollsmoother_speed', [
                    'label'      => esc_html__( 'Speed', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [],
                    'range'      => [
                        '' => [
                            'min'  => -5,
                            'max'  => 5,
                            'step' => .5
                        ]
                    ],
                    'default'    => [
                        'unit' => '',
                        'size' => 0.8
                    ],
                    'condition'  => [
                        'ext_gsap_scrollsmoother' => 'yes'
                    ],
                ]);
                $controls_stack->add_control( 'ext_gsap_scrollsmoother_lag', [
                    'label'      => esc_html__( 'Lag', 'onnat-extra' ),
                    'type'       => Elementor\Controls_Manager::SLIDER,
                    'size_units' => [],
                    'range'      => [
                        '' => [
                            'min'  => 0,
                            'max'  => 3,
                            'step' => .5
                        ]
                    ],
                    'default'    => [
                        'unit' => '',
                        'size' => 1
                    ],
                    'condition'  => [
                        'ext_gsap_scrollsmoother' => 'yes'
                    ],
                ]);
            $controls_stack->end_controls_section();
        }

        public function add_attributes( $element ) {

            $scrollsmoother = $element->get_settings( 'ext_gsap_scrollsmoother' );

            if( !empty( $scrollsmoother ) ) {
                $attributes = [];
                $speed      = $element->get_settings( 'ext_gsap_scrollsmoother_speed' );
                $lag        = $element->get_settings( 'ext_gsap_scrollsmoother_lag' );

                $attributes['data-gsap-smooth-scroll-speed'] = !empty( $speed['size'] ) ? $speed['size'] : 1;
                $attributes['data-gsap-smooth-scroll-lag']   = !empty( $lag['size'] ) ? $lag['size'] : 0;

                $element->add_render_attribute( '_wrapper', $attributes );
            }
        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_gsap_scroll_smoother' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_gsap_scroll_smoother() {

        return KinForce_Extra_Plugin_Elementor_Extension_GSAP_Scroll_Smoother::get_instance();
    }
}

kf_extra_plugin_elementor_extension_gsap_scroll_smoother();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */