<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Elementor_Extension_Motion_Fx' ) ) {

	/**
	 * Elementor Extension: Motion Effect setup class.
	 */
    class KinForce_Extra_Plugin_Elementor_Extension_Motion_Fx {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        /**
         * Contains default extension state.
         */
        private $active = true;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'elementor/init', [ $this, 'init' ] );

            do_action( 'kinfw-action/plugin/elementor/extensions/motion-fx/loaded' );

		}

        public function init() {

            $this->active = apply_filters( 'kinfw-filter/plugin/elementor/extensions/motion-fx', $this->active );

            if( $this->active ) {

                add_action('elementor/element/section/section_effects/after_section_start', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/column/section_effects/after_section_start', [ $this, 'register_section' ], 10, 2 );
                add_action('elementor/element/common/section_effects/after_section_start', [ $this, 'register_section' ], 10, 2 );

            }

        }

        public function register_section( $element, $section_id ) {

            $exclude  = [];
            $selector = '{{WRAPPER}}';

            if ( $element instanceof \Elementor\Element_Section ) {
                $exclude[] = 'motion_fx_mouse';
            } elseif ( $element instanceof \Elementor\Element_Column ) {
                $selector .= ' > .elementor-widget-wrap';
            } elseif ( $element instanceof \Elementor\Widget_Base ) {
                $selector .= ' > .elementor-widget-container';
            }

            $element->add_group_control( 'motion_fx', [
                'name'     => 'motion_fx',
                'selector' => $selector,
                'exclude'  => $exclude,
            ] );

        }

    }

}

if( !function_exists( 'kf_extra_plugin_elementor_extension_motion_fx' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_elementor_extension_motion_fx() {

        return KinForce_Extra_Plugin_Elementor_Extension_Motion_Fx::get_instance();
    }
}

kf_extra_plugin_elementor_extension_motion_fx();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */