<?php
/**
 * Widget Template : Accordion
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

/**
 * Setting Up Default Item
 */
    $default_item = '';
    if( $settings['active_accordion'] > 0 ) {
        $id = $settings['active_accordion'];
        $id--;

        $default_item = isset($items[$id]) ? 'elementor-repeater-item-'.$items[$id]['_id'] : $default_item;
    }

$this->add_render_attribute( 'main', [
    'id'                => 'kfw-ele-widget-accordion-'.esc_attr( $this->get_id() ),
    'class'             => [
        'kfw-ele-widget-accordion-main',
        empty( $settings['use_title_icon'] ) ? 'kfw-accordion-handler-icon-pos-'.esc_attr( $settings['handler_align'] ) : '',
    ],
    'data-default-item'  => $default_item,
    'data-multiple-open' => ( 'yes' === $settings['multiple_open'] ) ? 'true' : 'false'
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    foreach( $items as $index => $item ):

        $accordion_item = $this->get_repeater_setting_key( 'accordion_item', 'items', $index );
        $this->add_render_attribute( $accordion_item, [
            'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            'id'      => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            'class'   => array_filter([
                'kfw-elementor-accordion-item',
            ]),
        ]);

        echo '<div '.$this->get_render_attribute_string( $accordion_item ).'>';

            echo '<div class="kfw-accordion-header-wrap" data-id="elementor-repeater-item-'.esc_attr( $item['_id'] ).'">';
                /**
                 * Icon
                 */
                    if( $settings['use_title_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
                        if( $item['icon_type'] === 'icon' ) {
                            $this->_render_icon( $item['icon'] );
                        } else if( $item['icon_type'] === 'image' ) {
                            $this->_render_img( $item['image'] );
                        } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                            $src = '';
                            if( $item['icon_type'] === 'lordicon_media' ) {
                                $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                            } else if( $item['icon_type'] === 'lordicon_external' ) {
                                $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                            }

                            if( !empty( $src ) ) {
                                $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                                $this->add_render_attribute( $lordicon, [
                                    'class'   => 'kfw-elementor-lordicon',
                                    'src'     => $src,
                                    'stroke'  => 45,
                                    'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                    'trigger' => 'click'
                                ]);

                                /**
                                 * Colors
                                 */
                                    $colors = '';
                                    $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                    $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                    $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $lordicon, 'colors', $colors );
                                    }

                                echo '<div class="kfw-accordion-title-icon-wrap kfw-accordion-title-lordicon-type">';
                                    echo '<span class="kfw-elementor-icon-wrap">';
                                        echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                    echo '</span>';
                                echo '</div>';
                            }
                        }

                    }

                /**
                 * Title
                 */
                    $title     = trim( $item['title'] );
                    $sub_title = trim( $item['sub_title'] );
                    if( !empty( $title ) || !empty( $sub_title ) ) {
                        echo '<div class="kfw-accordion-title-wrap">';
                            if( !empty( $title ) ) {
                                echo '<div class="kfw-accordion-title">';
                                    echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
                                echo '</div>';
                            }

                            if( !empty( $sub_title ) ) {
                                echo '<div class="kfw-accordion-sub-title">';
                                    echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
                                echo '</div>';
                            }
                        echo '</div>';
                    }

                /**
                 * Handler
                 */
                    if( $settings['handler_icon_type'] !== 'blank' ) {
                        if( $settings['handler_icon_type'] === 'icon' ) {
                            echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-icon-type">';
                                $this->_render_handler_icon( $settings['handler_icon_icon'] );
                                $this->_render_handler_icon( $settings['handler_icon_active_icon'], $active = true );
                            echo '</div>';
                        } else if( $settings['handler_icon_type'] === 'image' ) {
                            echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-image-type">';
                                $this->_render_handler_icon_img( $settings['handler_icon_image'] );
                                $this->_render_handler_icon_img( $settings['handler_icon_active_image'], $active = true );
                            echo '</div>';
                        } else if( $settings['handler_icon_type'] === 'lordicon_media' ) {

                            $src    = !empty( $settings['handler_icon_lordicon_media']['url'] ) ? $settings['handler_icon_lordicon_media']['url'] : '';
                            $a_src  = !empty( $settings['handler_icon_active_lordicon_media']['url'] ) ? $settings['handler_icon_active_lordicon_media']['url'] : '';
                            $stroke = !empty( $settings['handler_media_stroke']['size'] ) ?  $settings['handler_media_stroke']['size']: 45;

                            /**
                             * Colors
                             */
                                $colors = '';
                                $colors .= !empty( $settings['handler_media_primary_color'] ) ? 'primary:'.$settings['handler_media_primary_color'].',': '';
                                $colors .= !empty( $settings['handler_media_secondary_color'] ) ? 'secondary:'.$settings['handler_media_secondary_color'].',': '';
                                $colors .= !empty( $settings['handler_media_tertiary_color'] ) ? 'tertiary:'.$settings['handler_media_tertiary_color'].',': '';

                            if( !empty( $src ) && !empty( $a_src ) ) {

                                echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-lordicon-type">';

                                    $handler_lordicon = $this->get_repeater_setting_key( 'handler-lordicon', 'items', $index );
                                    $this->add_render_attribute( $handler_lordicon, [
                                        'class'   => 'kfw-elementor-lordicon',
                                        'src'     => $src,
                                        'stroke'  => $stroke,
                                        'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                        'trigger' => 'click'
                                    ]);

                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $handler_lordicon, 'colors', $colors );
                                    }

                                    echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-close">';
                                        echo '<span class="kfw-elementor-icon-wrap">';
                                            echo '<lord-icon '. $this->get_render_attribute_string( $handler_lordicon ) .'></lord-icon>';
                                        echo '</span>';
                                    echo '</div>';

                                    $active_handler_lordicon = $this->get_repeater_setting_key( 'active-handler-lordicon', 'items', $index );
                                    $this->add_render_attribute( $active_handler_lordicon, [
                                        'class'   => 'kfw-elementor-lordicon',
                                        'src'     => $a_src,
                                        'stroke'  => $stroke,
                                        'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                        'trigger' => 'click'
                                    ]);

                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $active_handler_lordicon, 'colors', $colors );
                                    }

                                    echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-open">';
                                        echo '<span class="kfw-elementor-icon-wrap">';
                                            echo '<lord-icon '. $this->get_render_attribute_string( $active_handler_lordicon ) .'></lord-icon>';
                                        echo '</span>';
                                    echo '</div>';

                                echo '</div>';

                            }
                        } else if( $settings['handler_icon_type'] === 'lordicon_external' ) {
                            $src   = !empty( $settings['handler_icon_lordicon_external']['url'] ) ? $settings['handler_icon_lordicon_external']['url'] : '';
                            $a_src = !empty( $settings['handler_icon_lordicon_external']['url'] ) ? $settings['handler_icon_lordicon_external']['url'] : '';

                            $stroke = !empty( $settings['handler_media_stroke']['size'] ) ?  $settings['handler_media_stroke']['size']: 45;

                            /**
                             * Colors
                             */
                                $colors = '';
                                $colors .= !empty( $settings['handler_media_primary_color'] ) ? 'primary:'.$settings['handler_media_primary_color'].',': '';
                                $colors .= !empty( $settings['handler_media_secondary_color'] ) ? 'secondary:'.$settings['handler_media_secondary_color'].',': '';
                                $colors .= !empty( $settings['handler_media_tertiary_color'] ) ? 'tertiary:'.$settings['handler_media_tertiary_color'].',': '';

                            if( !empty( $src ) && !empty( $a_src ) ) {

                                echo '<div class="kfw-accordion-handler-icon-wrap kfw-accordion-handler-lordicon-type">';

                                    $handler_lordicon = $this->get_repeater_setting_key( 'handler-lordicon', 'items', $index );
                                    $this->add_render_attribute( $handler_lordicon, [
                                        'class'   => 'kfw-elementor-lordicon',
                                        'src'     => $src,
                                        'stroke'  => $stroke,
                                        'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                        'trigger' => 'click'
                                    ]);

                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $handler_lordicon, 'colors', $colors );
                                    }

                                    echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-close">';
                                        echo '<span class="kfw-elementor-icon-wrap">';
                                            echo '<lord-icon '. $this->get_render_attribute_string( $handler_lordicon ) .'></lord-icon>';
                                        echo '</span>';
                                    echo '</div>';

                                    $active_handler_lordicon = $this->get_repeater_setting_key( 'active-handler-lordicon', 'items', $index );
                                    $this->add_render_attribute( $active_handler_lordicon, [
                                        'class'   => 'kfw-elementor-lordicon',
                                        'src'     => $a_src,
                                        'stroke'  => $stroke,
                                        'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                        'trigger' => 'click'
                                    ]);

                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $active_handler_lordicon, 'colors', $colors );
                                    }

                                    echo '<div class="kfw-accordion-handler-icon kfw-accordion-handler-open">';
                                        echo '<span class="kfw-elementor-icon-wrap">';
                                            echo '<lord-icon '. $this->get_render_attribute_string( $active_handler_lordicon ) .'></lord-icon>';
                                        echo '</span>';
                                    echo '</div>';

                                echo '</div>';

                            }
                        }
                    }

            echo '</div>';


            /**
             * Content
             */
                $item_src           = $item['source'];
                $accordion_con_item = $this->get_repeater_setting_key( 'accordion_con_item', 'items', $index );

                $this->add_render_attribute( $accordion_con_item, [
                    'class'   => array_filter([
                        'kfw-accordion-content-wrap',
                        'kfw-accordion-content-'.$item_src.'-type',
                    ]),
                    'hidden' => 'hidden',
                    'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                ]);

                echo '<div '.$this->get_render_attribute_string( $accordion_con_item ).'>';
                    if( $item_src === 'editor' ) {
                        echo $this->parse_text_editor( $item['editor'] );
                    } else if( $item_src === 'template' && ( $item['template'] != '0' && !empty( $item['template'] ) ) ) {
                        echo $this->_generate_template_content( $item['template'] );
                    }
                echo '</div>';

        echo '</div>';

    endforeach;

echo '</div>';