<?php
/**
 * Widget Template : Airborne Elements
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-airborne-eles-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-airborne-eles-main',
    ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    foreach( $items as $index => $item ):
        $element = $this->get_repeater_setting_key( 'element', 'items', $index );
        $this->add_render_attribute( $element, [
            'id'      => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            'class'   => array_filter([
                'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                $item['animation'],
                'kfw-elementor-airborne-item',
            ]),
        ]);

        if( !empty( $item['gsap_scroll_smoother'] ) ) {
            $attributes = [];
            $speed      = $item['gsap_scroll_smoother_speed'];
            $lag        = $item['gsap_scroll_smoother_lag'];

            $attributes['data-gsap-smooth-scroll-speed'] = !empty( $speed['size'] ) ? $speed['size'] : 1;
            $attributes['data-gsap-smooth-scroll-lag']   = !empty( $lag['size'] ) ? $lag['size'] : 0;

            $this->add_render_attribute( $element, $attributes );
        }
        

        /**
         * Device Hidden Class
         */
        $this->add_render_attribute( $element, 'class', $this->hidden_class( $item ) );

        echo '<div '.$this->get_render_attribute_string( $element ).'>';
            if( $item['type'] === 'icon' ) {
                $this->_render_icon( $item['icon'] );
            } else if( $item['type'] === 'image' ) {
                $this->_render_img( $item['image'] );
            } else if( $item['type'] === 'text' ) {
                printf("<span class='kfw-elementor-airborne-text-item'> %s </span>", $item["text"] );
            } else if( $item['type'] === 'blank' ) {
                echo "<span class='kfw-elementor-airborne-blank-item'></span>";
            }
        echo '</div>';
    endforeach;

echo '</div>';