<?php
/**
 * Widget Template : Blog Post Single - Author Box
 */

$settings   = $this->get_settings();
$post_id    = get_the_ID();
$mode       = $this->_is_editor_mode();

if( $mode ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'post' );
}

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-post-author-box-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-post-author-box-main',
    ],
]);

$sizes = array_filter( $settings['avatar_size'] );
$size  = isset( $sizes['size'] ) ? $sizes['size'] : 160;

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    if( 'post-author' === $settings['type'] ) {
        $author_id        = get_post_field( 'post_author', $post_id );
        $author_desc      = get_the_author_meta( 'description', $author_id );
        $author_img       = get_avatar( $author_id, $size );
        $author_name      = get_the_author_meta( 'display_name', $author_id );
        $author_posts_url = get_author_posts_url( $author_id );

        printf( '
            <div class="kinfw-author-box">
                <div class="kinfw-author-img"> %1$s </div>
                <div class="kinfw-author-info">
                    <span class="kinfw-author-name"> <a href="%2$s"> %3$s </a> </span>
                    <div class="kinfo-author-desc"> %4$s </div>
                </div>
            </div>',
            $author_img,
            $author_posts_url,
            $author_name,
            wp_kses_post( wpautop( $author_desc ) )
        );
    } else {
        /**
         * Author Image
         */
            $author_img = '';
            if( !empty( $settings['avatar']['url'] ) ) {
                $author_img = sprintf(
                    '<img src="%1$s" width="%2$s" height="%2$s"/>',
                    esc_url( $settings['avatar']['url'] ),
                    $size
                );
            }

        /**
         * Author Name
         */
            $author_name = '';
            if( !empty( $settings['name'] ) ) {
                if( !empty( $settings['link']['url'] ) ) {
                    $author_name = sprintf(
                        '<span class="kinfw-author-name"><a href="%1$s"> %2$s </a></span>',
                        $settings['link']['url'],
                        $settings['name']
                    );
                } else {
                    $author_name = sprintf(
                        '<span class="kinfw-author-name">%1$s</span>',
                        $settings['name']
                    );
                }
            }

        /**
         * Author Description
         */
            $author_desc = '';
            if( !empty( $settings['description'] ) ) {
                $author_desc = sprintf(
                    '<div class="kinfo-author-desc"> %1$s </div>',
                    wp_kses_post( wpautop( $settings['description'] ) )
                );
            }

            printf( '
                <div class="kinfw-author-box">
                    <div class="kinfw-author-img"> %1$s </div>
                    <div class="kinfw-author-info"> %2$s %3$s </div>
                </div>',
            $author_img,
            $author_name,
            $author_desc,
        );
    }
echo '</div>';