<?php
/**
 * Widget Template :  CPT Project Post Single Meta
 */

$settings = $this->get_settings();
$post_id  = get_the_ID();
$mode     = $this->_is_editor_mode();

if( $mode ) {
    $post_id = kf_extra_plugin_elementor()->get_latest_post_id( 'kinfw-project' );
}

if( empty( $settings['meta'] ) ) {
    return;
}

$title = '';
$data  = '';

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-project-meta-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-project-meta-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $meta  = get_post_meta( $post_id, '_kinfw_cpt_project_options', true );
    $meta  = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

    if( 'yes' === $settings['add_title'] ) {

        $title = $settings['title'];

        if( empty( $title ) ) {

            switch( $settings['meta'] ) {
                case 'category':
                    $title = esc_html__('Category:', 'onnat-extra');
                break;

                case 'customer':
                    $title = esc_html__('Customer:', 'onnat-extra');
                break;

                case 'startdate':
                    $title = esc_html__('Start Date:', 'onnat-extra');
                break;

                case 'enddate':
                    $title = esc_html__('End Date:', 'onnat-extra');
                break;

                case 'rating':
                    $title = esc_html__('Rating:', 'onnat-extra');
                break;

                case 'website':
                    $title = esc_html__('Website:', 'onnat-extra');
                break;
            }
        }

        if( !empty( $title ) ) {
            printf( '<span class="kfw-ele-cpt-project-meta-title">%s</span>', esc_html( $title ) );
        }

    }

    switch( $settings['meta'] ) {
        case 'customer':
            $data = isset( $meta['customer'] ) ? $meta['customer'] : false;
        break;

        case 'startdate':
            $data   = isset( $meta['datetime']['from'] ) ? $meta['datetime']['from'] : false;
            $format = $settings['date_format'];
            $format = ( $format == 'custom' ) ? $settings['custom_date_format'] : $format;

            if( $data ) {
                $data = wp_date( $format, strtotime( $data ) );
            }
        break;

        case 'enddate':
            $data   = isset( $meta['datetime']['to'] ) ? $meta['datetime']['to'] : false;
            $format = $settings['date_format'];
            $format = ( $format == 'custom' ) ? $settings['custom_date_format'] : $format;

            if( $data ) {
                $data = wp_date( $format, strtotime( $data ) );
            }
        break;

        case 'rating':
            $data = isset( $meta['rating'] ) ? $meta['rating'] : false;
            if( $data > 0 ) {
                $data = sprintf( '<div class="kfw-project-star-rating"><span style="width:%s%%"></span></div>', ( ( $data / 5 ) * 100 ) );
            }
        break;

        case 'website':
            $website = isset( $meta['website'] ) ? $meta['website'] : [];
            $website = apply_filters( 'kinfw-filter/theme/util/is-array', $website );

            if( !empty( $website ) ) {
                $data = sprintf( '<a href="%s" target="%s"> %s </a>',
                    esc_url( $website['url'] ),
                    esc_attr( $website['target'] ),
                    esc_html( $website['text'] )
                );
            }
        break;

        case 'category':
            $terms_list = get_the_term_list( $post_id, 'kinfw-project-category', '', ', ', '' );

            if ( $terms_list ) {
                $data = sprintf( '
                    <ul class="kinfw-project-tax-list">
                        <li>
                            %1$s
                        </li>
                    </ul>',
                    str_replace( ', ', ', </li> <li>', $terms_list )
                );
            }
        break;
    }

    if( !empty( $data ) ) {
        printf( '<span class="kfw-ele-cpt-project-meta-data">%s</span>', $data );
    }
echo '</div>';