<?php
/**
 * Widget Template : Portfolio Template
 */

$settings = $this->get_settings();
$layout   = $settings['layout'];

$this->add_render_attribute( 'main', [
    'id'    => 'kfw-ele-widget-cpt-project-tpl-'.esc_attr( $this->get_id() ),
    'class' => [
        'kfw-ele-widget-cpt-project-tpl-main',
        'kfw-ele-widget-cpt-project-tpl-'. $layout
    ]
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $args      = $this->get_args( $settings );
    $the_query = new WP_Query( $args );

    if( $the_query->have_posts() ) {

        echo '<div class="kinfw-project-posts-wrap">';

        if( $layout == 'grid-1' ) {

            while( $the_query->have_posts() ) {

                $the_query->the_post();

                get_template_part( 'template-parts/archive/kinfw-project/grid-1/content', $settings['type'] );

            }

        } else if( $layout == 'masonry' ) {

            echo '<div class="kinfw-project-grid-sizer kinfw-col-3"></div>';

            while( $the_query->have_posts() ) {

                $the_query->the_post();

                $post_id = get_the_ID();
                $meta    = get_post_meta( $post_id, '_kinfw_cpt_project_options', true );
                $meta    = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

                $masonry_layout_mode = isset( $meta['masonry_layout_mode'] ) ? $meta['masonry_layout_mode'] : 'kinfw-masonry-item kinfw-col-lg-6 kinfw-col-md-6 kinfw-col-12';

                $classes = $masonry_layout_mode;

                get_template_part(
                    'template-parts/archive/kinfw-project/masonry/content', $settings['type'],
                    [ 'classes' => $classes ]
                );

            }

        }

        echo '</div>';

        // Pagination
        $pagination = paginate_links([
            'total'     => $the_query->max_num_pages,
            'end_size'  => 4,
            'prev_text' => kinfw_icon( 'onnat-line-arrow-long-left-tiny' ),
            'next_text' => kinfw_icon( 'onnat-line-arrow-long-right-tiny' ),
        ]);

        if( $pagination ) :
            printf( '<div id="kinfw-blog-pagination">%1$s</div>', _navigation_markup( $pagination ) );
        endif;

    } else {
        get_template_part( 'content', 'none' );
    }

    wp_reset_postdata();

echo '</div>';