<?php
/**
 * Widget Template : Service Grid
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-service-grid-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-service-grid-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    foreach( $items as $index => $item ) {
        if( empty( $item['service'] ) ) {
            break;
        }

        $service      = get_post( $item['service'], ARRAY_A );
        $post_id      = $service['ID'];
        $post_title   = get_the_title( $post_id );
        $post_link    = get_permalink( $post_id );
        $post_excerpt = get_the_excerpt( $post_id );
        $terms_list   = get_the_term_list(
            $post_id,
            'kinfw-service-group',
            '<ul class="kinfw-service-terms-list"><li>',
            ', </li> <li>',
            '</li></ul>'
        );

        $s_item  = $this->get_repeater_setting_key( 's-item', 's-items', $index );
        $classes = [
            'kinfw-service-item',
            'kfw-ele-widget-cpt-service-grid-item',
            'elementor-repeater-item-' . esc_attr( $item['_id'] ),
            $item['animation'],
        ];

        $this->add_render_attribute( $s_item, [
            'id'    => 'post-'.$post_id,
            'class' => array_filter( $classes )
        ] );

        echo '<article '. $this->get_render_attribute_string( $s_item ) .'>';

            echo '<div class="kinfw-service-info-wrap">';

                /**
                 * Title
                 */
                printf( '<div class="kinfw-service-title-wrap">
                        %1$s <div class="kinfw-service-title">%2$s</div>
                    </div>',
                    $terms_list,
                    $post_title
                );

                /**
                 * Icon
                 */
                if( $item['icon-type'] === 'icon' ) {
                    $this->_render_icon( $item['icon'] );
                } else if( $item['icon-type'] === 'image' ) {
                    $this->_render_img( $item['image'] );
                }

                /**
                 * Excerpt
                */
                printf( '<div class="kinfw-service-excerpt">%1$s</div>',
                    $post_excerpt
                );
            echo '</div>';

            /**
              * Button
              */
            printf( '<div class="kinfw-service-button-wrap">
                    <a href="%1$s">%2$s</a>
                </div>',
                esc_url( $post_link ),
                ( $settings['button-icon-type'] === 'icon' ) ?
                    $this->_render_button_icon( $settings['button-icon'] ) :
                    $this->_render_button_img( $settings['button-image'] )
            );

        echo '</article>';
    }

echo '</div>';