<?php
/**
 * Widget Template : Team Member Grid
 */

$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-cpt-team-member-grid-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-cpt-team-member-grid-main' ],
] );

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    foreach( $items as $index => $item ) {
        $member  = get_post( $item['member'], ARRAY_A );

        $post_id    = $member['ID'];
        $post_title = get_the_title( $post_id );
        $post_link  = get_permalink( $post_id );
        $terms_list = get_the_term_list( $post_id, 'kinfw-team-group', '', ', ', '' );

        $t_item  = $this->get_repeater_setting_key( 't-item', 't-items', $index );
        $classes = [
            'kinfw-team-member-item',
            'kfw-ele-widget-cpt-team-member-grid-item',
            esc_attr( $settings['layout'] ),
            'elementor-repeater-item-' . esc_attr( $item['_id'] ),
        ];

        $this->add_render_attribute( $t_item, [
            'id'    => 'post-'.$post_id,
            'class' => array_filter( $classes )
        ] );

        /**
         * Social Links
         */
            $social_links        = $settings['socials'];
            $active_social_links = [];

            foreach( $social_links as $social_link ) {
                if( 'yes' === $social_link['status'] ) {
                    array_push( $active_social_links, $social_link['social']);
                }
            }

            $links = [];
            $meta  = get_post_meta( $post_id, '_kinfw_cpt_team_member_options', true );
            $meta  = apply_filters( 'kinfw-filter/theme/util/is-array', $meta );

            foreach( $active_social_links as $social_id ) {
                if( isset( $meta[ $social_id ] ) && !empty( $meta[ $social_id ] ) ) {
                    $links[ $social_id ] = $meta[ $social_id ];
                }
            }        

        echo '<article '. $this->get_render_attribute_string( $t_item ) .'>';
            /**
             * Media
             */
                $media = '';

                if( has_post_thumbnail( $post_id ) ) {
                    $media = get_the_post_thumbnail( $post_id, 'full' );
                } else {
                    $media = sprintf( '
                        <img src="%1$s" alt="%2$s" class="kinfw-transparent-img"/>',
                        get_theme_file_uri( 'assets/image/public/transparent.jpg' ),
                        $post_title
                    );
                }

                echo '<div class="kinfw-team-member-image-wrap">';
                    echo $media;
                    if( count( $links ) ) {
                        if( $settings['layout'] === 'kinfw-team-member-grid-style-4' ) {
                            echo '<ul class="kinfw-social-links">';
                                foreach( $links as $social_id => $social_link ) {
                                    printf( '<li> <a href="%s"></a> </li>', $social_link );
                                }
                            echo '</ul>';                            
                        }
                    }    
                echo '</div>';

            /**
             * Social Links
             */
                if( count( $links ) ) {
                    if( $settings['layout'] === 'kinfw-team-member-grid-style-3' ) {
                        echo '<div class="kinfw-social-wrapper">';
                            echo '<div class="kinfw-social-icon">';
                                echo '<span class="kinfw-icon kinfw-icon-math-plus"></span>';
                                echo '<span class="kinfw-icon kinfw-icon-math-minus"></span>';
                            echo '</div>';

                            echo '<ul class="kinfw-social-links">';
                                foreach( $links as $social_id => $social_link ) {
                                    printf( '<li> <a href="%s"></a> </li>', $social_link );
                                }
                            echo '</ul>';

                        echo '</div>';
                    } else if( in_array( $settings['layout'], [ 'kinfw-team-member-grid-style-1', 'kinfw-team-member-grid-style-2' ] ) ) {
                        echo '<ul class="kinfw-social-links">';
                            foreach( $links as $social_id => $social_link ) {
                                printf( '<li> <a href="%s"></a> </li>', $social_link );
                            }
                        echo '</ul>';
                    }
                }

            /**
             * Content Wrap
             */
                echo '<div class="kinfw-team-member-content-wrap">';
                    if( count( $links ) ) {
                        if( $settings['layout'] === 'kinfw-team-member-grid-style-5' ) {
                            echo '<ul class="kinfw-social-links">';
                                foreach( $links as $social_id => $social_link ) {
                                    printf( '<li> <a href="%s"></a> </li>', $social_link );
                                }
                            echo '</ul>';
                        }
                    }
                    
                    printf( ' <h6><a href="%s">%s</a></h6> %s',
                        esc_url( $post_link ),
                        esc_html( $post_title ),
                        $terms_list ? sprintf( '<p>%s</p>', $terms_list ) : ''
                    );
                echo '</div>';

        echo '</article>';
    }
echo '</div>';