<?php
/**
 * Widget Template : Flip Box Cube
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-ele-widget-flip-box-cube-'.esc_attr( $this->get_id() ),
	'class' => array_filter( [
		'kfw-ele-widget-flip-box-cube-wrap',
        !empty( $settings['graphic_element'] ) ? 'kfw-ele-widget-flip-box-cube-graphic-ele-'. $settings['graphic_element'] : '',
	] ),
	'dir'   => is_rtl() ? 'rtl' : 'ltr'
]);

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';
	echo '<div class="kfw-ele-widget-flip-box-cube">';
		echo '<div class="kfw-ele-widget-flip-box-cube-inner">';

			/**
			 * Front Side
			 */
				echo '<div class="kfw-ele-widget-flip-box-front kfw-ele-widget-flip-box-layer">';
					echo '<div class="kfw-ele-widget-flip-box-layer-overlay">';
						echo '<div class="kfw-ele-widget-flip-box-layer-inner">';

							/**
							 * Graphic Element
							 */
								if( $settings['graphic_element'] !== 'blank'  ) {
									if( $settings['graphic_element'] === 'icon'  ) {
										$this->_render_icon( $settings['icon'] );
									} else if(  $settings['graphic_element'] === 'image' ) {
										$image_src = $this->_get_image_src( $settings['image']['id'], 'image_size', $settings );
										$image_src = empty($image_src) ? $settings['image']['url'] : $image_src;

										$image_title = $this->_get_image_title( $settings['image'] );
										$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

										$image_alt = $this->_get_image_alt( $settings['image'] );
										$image_alt = empty( $image_alt ) ? $image_title : $image_title;

										$this->add_render_attribute( 'image_attr', [
											'class' => 'kfw-image-is-loading',
											'alt'   => esc_attr( $image_alt ),
											'title' => esc_attr( $image_title ),
											'src'   => esc_url( $image_src ),
										]);
										echo '<div class="kfw-elementor-icon-wrap">';
											echo '<img '.$this->get_render_attribute_string( 'image_attr' ).'/>';
										echo '</div>';
									}
								}

							/**
							 * Title
							 */
							if( !empty( $settings['front_title'] ) ){
								printf( '<div class="kfw-ele-widget-flip-box-layer-title">%s</div>', esc_html( $settings['front_title'] ) );
							}

							/**
							 * Sub Title
							 */
							if( !empty( $settings['front_sub_title'] ) ){
								printf( '<div class="kfw-ele-widget-flip-box-layer-sub-title">%s</div>', esc_html( $settings['front_sub_title'] ) );
							}

							/**
							 * Description
							 */
							if( !empty( $settings['front_description'] ) ){
								printf( '<div class="kfw-ele-widget-flip-box-layer-description">%s</div>', $settings['front_description'] );
							}
						echo '</div>';
					echo '</div>';
				echo '</div>';

			/**
			 * Back Side
			 */
				$back_classes = [
					'kfw-ele-widget-flip-box-back',
					'kfw-ele-widget-flip-box-layer'
				];

				if( 'box' === $settings['link_click']) {
					$back_classes[] = 'kfw-ele-widget-flip-box-clickable';

					if ( ! empty( $settings['back_btn_link']['url'] ) ) {
						$this->add_render_attribute( 'back', 'data-link', esc_url( $settings['back_btn_link']['url'] ) );

						if ( ! empty( $settings['back_btn_link']['is_external'] ) ) {
							$this->add_render_attribute( 'back', 'data-target', '_blank' );
						}
					}
				}

				$this->add_render_attribute( 'back', [
					'class' => $back_classes,
				]);

				echo '<div '.$this->get_render_attribute_string('back').'>';
					echo '<div class="kfw-ele-widget-flip-box-layer-overlay">';
						echo '<div class="kfw-ele-widget-flip-box-layer-inner">';
							/**
							 * Title
							 */
							if( !empty( $settings['back_title'] ) ){
								printf( '<div class="kfw-ele-widget-flip-box-layer-title">%s</div>', esc_html( $settings['back_title'] ) );
							}

							/**
							 * Sub Title
							 */
							if( !empty( $settings['back_sub_title'] ) ){
								printf( '<div class="kfw-ele-widget-flip-box-layer-sub-title">%s</div>', esc_html( $settings['back_sub_title'] ) );
							}

							/**
							 * Description
							 */
							if( !empty( $settings['back_description'] ) ){
								printf( '<div class="kfw-ele-widget-flip-box-layer-description">%s</div>', $settings['back_description'] );
							}

							/**
							 * Button
							 */
							$this->_button( $settings );

						echo '</div>';
					echo '</div>';
				echo '</div>';

			/**
			 * X-Flank & Y-Flank
			 */
				echo '<div class="kfw-ele-widget-flip-box-yflank"></div>';
				echo '<div class="kfw-ele-widget-flip-box-xflank"></div>';

		echo '</div>';
	echo '</div>';
echo '</div>';