<?php
/**
 * Widget Template : Google Map
 */

$settings = $this->get_settings();
$api_key  = $this->gmap_api_key;

$this->add_render_attribute( 'main', [
	'id'            => 'kfw-ele-widget-google-map-'.esc_attr( $this->get_id() ),
	'class'         => [ 'kfw-ele-widget-google-map-main' ],
	'data-settings' => $this->_generate_setting_json( $settings ),
	'data-markers'  => $this->_generate_markers( $settings ),
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	if( empty( $api_key ) ) {
		$this->_message( esc_html__('To utilize this element, set your Google Map API key within the theme settings panel.', 'onnat-extra' ) );
	} else {
		echo '<div class="kfw-ele-widget-google-map"></div>';
	}

echo '</div>';