<?php
/**
 * Widget Template : Magnetic Button
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-magnetic-button-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-magnetic-button-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'btn-wrap', [
        'class' => array_filter([
            'kfw-ele-widget-button-wrap',
            !empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-button-has-txt' : '',
            'kfw-ele-widget-button-icon-position-' . $settings['btn_icon_pos'],
        ])
    ]);
    echo '<div '.$this->get_render_attribute_string( 'btn-wrap' ).'>';

        $this->add_render_attribute( 'btn', [
            'class' => array_filter([ 'kfw-ele-widget-magnetic-button' ]),
        ]);

        /**
         * Link
         */
        $link = array_filter( $settings['btn_link'] );
        if ( ! empty( $link['url'] ) ) {
            $this->add_render_attribute( 'btn', 'href', esc_url( $link['url'] ) );

            if ( ! empty( $link['is_external'] ) ) {
                $this->add_render_attribute( 'btn', 'target', '_blank' );
            }

            if ( ! empty( $link['nofollow'] ) ) {
                $this->add_render_attribute( 'btn', 'rel', 'nofollow' );
            }
        }

        echo '<a '.$this->get_render_attribute_string( 'btn' ).'>';

            if( !empty( trim( $settings['btn_text'] ) ) ) {
                printf( '<span class="kfw-elementor-button-text"> <span>%1$s</span> <span>%1$s</span> </span>', esc_html( $settings['btn_text'] ) );
            }

            $this->_render_icon( $settings['btn_icon'] );

        echo '</a>';

    echo '</div>';

echo '</div>';