<?php
/**
 * Widget Template : Mobile Menu
 */

$settings = $this->get_settings();
$menu     = $settings['menu'];

if( !$menu && empty( $menu )  ) {
	return;
}

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-mobile-menu-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-mobile-menu-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';
    echo '<div class="kinfw-navigation-holder kinfw-mobile-navigation-holder">';
        echo '<div class="kinfw-mobile-navigation-trigger">';
			if( 'theme' === $settings['menu_trigger_icon_type'] ) {
				echo '<span class="kfw-elementor-icon-wrap">';
					echo kinfw_icon( 'misc-bars', '', 'i' );
				echo '</span>';
			} else {
				$this->_render_icons( $settings['menu_trigger_icon'] );
			}
        echo '</div>';

		wp_nav_menu([
			'menu'            => $menu,
			'container'       => 'nav',
			'container_id'    => '',
			'container_class' => 'kinfw-mobile-menu-nav',
			'fallback_cb'     => false,
			'echo'            => true,
			'walker'          => new Onnat_Theme_Mobile_Nav_Menu_Walker,
			'items_wrap'      => '<ul class="kinfw-mobile-menu">
                <li class="kinfw-mobile-menu-close">
                    <a href="javascript:void(0);">' . kinfw_icon( 'math-cross' ) . '</a>
                </li>
                %3$s
            </ul>
            <div class="kinfw-mobile-menu-overlay"></div>',
		]);

    echo '</div>';
echo '</div>';