<?php
/**
 * Widget Template : Pricing Table Shape Header
 */

$settings = $this->get_settings();
$this->add_render_attribute( 'wrapper', [
	'id'    => 'kfw-ele-pricing-table-shape-header-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-pricing-table-shape-header-wrapper' ],
	'dir'   => is_rtl() ? 'rtl' : 'ltr'
]);

    /**
     * Pricing Table Animation
     */
    if( $settings['add_table_animation_hover'] == 'yes' && !empty( $settings['table_animation_hover'] ) ) {
        $this->add_render_attribute( 'wrapper', [
            'class' => [ 'elementor-animation-'.esc_attr( $settings['table_animation_hover'] ) ],
        ] );
    }

echo '<div '.$this->get_render_attribute_string( 'wrapper' ).'>';

	/**
	 * Currency & Price
	 */
		$currency_html = '';
		$symbol        = $settings['currency_symbol'];
		$price_format  = $settings['price_format'];
		$delimiter     = ( $price_format == 'sub' || $price_format == 'sup' ) ? '.' : ' ';
		$price         = explode( $delimiter, $settings['price'] );
		$price1        = $price[0];
		$price2        = '';

		if( count( $price ) === 2 ) {
			$price2 = $price[1];
		}

		if( !empty( $symbol ) ) {

			if( $symbol == 'custom' ) {
				$symbol = $settings['currency_symbol_custom'];
			} else {
				$symbol = kf_extra_plugin_elementor()->get_currency_symbol( $symbol );
			}

			$currency_html .= sprintf( '<%1$s class="kfw-ele-pricing-table-price-currency">%2$s</%1$s>',
				esc_html( $settings['currency_symbol_format'] ),
				esc_html( $symbol )
			);
		}

		if( $price_format == 'sub' || $price_format == 'sup' ) {

			if( !empty( $price1 ) ) {
				$currency_html .= sprintf( '<span class="kfw-ele-pricing-table-price-numeric" data-toval="%1$s" data-round="0"></span>',
					esc_html( $price1 )
				);
			}

			if( 0 < $price2 ) {
				$currency_html .= sprintf( '<%1$s class="kfw-ele-pricing-table-price-fractional" data-toval="%2$s"></%1$s>',
					esc_html( $price_format ),
					esc_html( $price2 )
				);
			}
		} else {
			$price      = explode( ".", $settings['price'] );
			$fractional = 0;

			if( count( $price ) === 2 ) {
				$fractional = strlen( $price[1] );
			}

			$currency_html .= sprintf( '<span class="kfw-ele-pricing-table-price-numeric" data-toval="%1$s" data-round="%2$s"></span>',
				esc_html( $price1 ),
				esc_html( $fractional )
			);
		}

        $period = $settings['period'];
        if( !empty( $settings['price'] ) && !empty( $period) ) {
            $period = sprintf( "<div class='kfw-ele-pricing-table-period'>%s</div>", esc_html( $period )  );
        }

		printf( '<div class="kfw-ele-pricing-table-currency kfw-ele-pricing-table-pricing-align-%s">',$settings['pricing_align'] );

			printf( '<div class="kfw-ele-pricing-table-price-wrapper">%s</div>',$currency_html );

			$period = $settings['period'];
			if( !empty( $settings['price'] ) && !empty( $period) ) {
				printf( '<div class="kfw-ele-pricing-table-period">%s</div>',$period);
			}

			/**
			 * Ribbon
			 */
				$this->_ribbon( $settings );

			/**
			 * Shape
			 */
				if( !empty( $settings['shape'] ) ) {
					$negative = ! empty( $settings[ 'shape_negative' ] );
					$this->shape_divider( $settings['shape'], $negative );
				}

		printf( '</div>' );

	/**
	 * Title & Sub Title
	 */
		$this->_titles( $settings );

	/**
	 * Features
	 */
		$features = array_filter(  $settings['features'] );
		if( !empty( $features )) {

			$values = array_filter( array_column( $features, 'value' ) );

			$this->add_render_attribute( 'features-list', [
				'class' => array_filter( [
					'kfw-ele-pricing-table-features-list',
					( $settings['show_item_divider'] == "yes" ) ? 'kfw-ele-pricing-table-features-list-has-divider' : '',
					( count( $values ) > 0  ) ? 'kfw-ele-pricing-table-features-list-has-values' : '',
				])
			]);

			echo '<ul '. $this->get_render_attribute_string( 'features-list' ) .'>';
			foreach( $features as $index => $item ) {

				$feature = $this->get_repeater_setting_key( 'feature', 'features', $index );

				$this->add_render_attribute( $feature, [
					'class' => array_filter( [
						'kfw-ele-pricing-table-features-list-item',
						'elementor-repeater-item-' . esc_attr( $item['_id'] ),
						( $item['status'] == "yes" ) ? 'kfw-ele-pricing-table-features-list-active-item' : 'kfw-ele-pricing-table-features-list-inactive-item',
						( $item['bold'] == "yes" ) ? 'kfw-ele-pricing-table-features-list-bold-item-label' : ''
					])
				]);

				echo '<li '. $this->get_render_attribute_string( $feature ) .'>';

					/**
					 *  Feature Label
					 */
					if( !empty( $item['label'] ) ) {
						echo "<span class='kfw-ele-pricing-table-features-list-item-label'>";
							$this->_render_icons( $item['icon'] );
							echo esc_html( $item["label"] );
						echo "</span>";
					}

					/**
					 *  Feature Value
					 */
					if( !empty( $item['value'] ) ) {
						printf("<span class='kfw-ele-pricing-table-features-list-item-value'> %s </span>", esc_html( $item["value"] ) );
					}
				echo '</li>';
			}
			echo '</ul>';
		}

    /**
     * Button
     */
		$this->_button( $settings );

echo '</div>';