<?php
/**
 * Widget Template : Ripple Button
 */
$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-ripple-button-'.esc_attr( $this->get_id() ),
	'class' => [ 
		'kfw-ele-widget-ripple-button-main',
		'kfw-ele-widget-ripple-button-align-'.$settings['button_align']
	],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	$this->add_render_attribute( 'btn-wrap', [
		'class' => array_filter([
			'kfw-ele-widget-ripple-button-wrap',
			!empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-ripple-button-has-txt' : ''
		])
	]);
	echo '<div '.$this->get_render_attribute_string( 'btn-wrap' ).'>';

		$this->add_render_attribute( 'btn', [
			'class' => array_filter([
				'kfw-ele-widget-ripple-button',
			])
		]);

        /**
         * Button Icon related classes
         */
		if( $settings['btn_icon']['value'] !== '' ) {
			$this->add_render_attribute( 'btn', [
				'class' => array_filter([
					!empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-ripple-button-icon-position-'.$settings['btn_icon_pos'] : '',
				])
			]);
		}

        /**
         * Link
         */
		$link = array_filter( $settings['btn_link'] );
		if ( ! empty( $link['url'] ) ) {
			$this->add_render_attribute( 'btn', 'href', esc_url( $link['url'] ) );

			if ( ! empty( $link['is_external'] ) ) {
				$this->add_render_attribute( 'btn', 'target', '_blank' );
			}

			if ( ! empty( $link['nofollow'] ) ) {
				$this->add_render_attribute( 'btn', 'rel', 'nofollow' );
			}
		}

		echo '<a '.$this->get_render_attribute_string( 'btn' ).'>';

			if( $settings['btn_icon_pos'] === 'left' ) {
				$this->_render_icon( $settings['btn_icon'] );
			}

            if( !empty( trim( $settings['btn_text'] ) ) ) {
                printf( '<span class="kfw-elementor-button-text">%s</span>', esc_html( $settings['btn_text'] ) );
            }

			if( $settings['btn_icon_pos'] === 'right' ) {
				$this->_render_icon( $settings['btn_icon'] );
			}

			echo '<span class="kfw-ele-widget-ripple-button-hover"></span>';

		echo '</a>';

    echo '</div>';

echo '</div>';