<?php
/**
 * Widget Template : Split Scroll
 */
$settings = $this->get_settings();
$items    = array_filter(  $settings['items'] );

if ( empty( $items ) ) {
    return;
}

$this->add_render_attribute( 'main', [
	'id'               => 'kfw-ele-widget-split-scroll-'.esc_attr( $this->get_id() ),
	'class'            => [
		'kfw-ele-widget-split-scroll-main',
		'kfw-ele-widget-split-scroll-'.esc_attr( $settings['layout_type'] ),
		'kfw-ele-widget-split-scroll-'.esc_attr( $settings['content_type'] ),
	],
	'data-split-style' => $settings['split_type'],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

	/**
	 * Left
	 */
	echo '<div class="kfw-elementor-split-scroll-items-wrap kfw-elementor-split-scroll-l-items-wrap">';
		foreach( $items as $index => $item ):

			$l_item = $this->get_repeater_setting_key( 'l_item', 'items', $index );
			$this->add_render_attribute( $l_item, [
				'id'      => 'elementor-repeater-l-item-' . esc_attr( $item['_id'] ),
				'class'   => array_filter([
					'kfw-elementor-split-scroll-item',
					'kfw-elementor-split-scroll-l-item',
					'kfw-elementor-split-scroll-content-item',
				]),
			]);

			echo '<div '.$this->get_render_attribute_string( $l_item ).'>';

				$mobile_image = array_filter( $item['main_image_image'] );
				if( isset( $mobile_image['url'] ) && !empty( $mobile_image['url'] ) ) {
					$image_attr = $this->get_repeater_setting_key( 'mobile-image-item', 'items', $index );

					$image_title = $this->_get_image_title( $mobile_image );
					$image_title = empty( $image_title ) ? $this->get_title() : $image_title;

					$image_alt = $this->_get_image_alt( $mobile_image );
					$image_alt = empty( $image_alt ) ? $image_title : $image_title;

					$this->add_render_attribute( $image_attr, [
						'class' => 'kfw-elementor-split-scroll-image',
						'alt'   => esc_attr( $image_alt ),
						'title' => esc_attr( $image_title ),
						'src'   => esc_url( $mobile_image['url'] ),
					]);

					echo '<div class="kfw-split-scroll-mobile-img-wrap">';
						echo '<img '.$this->get_render_attribute_string( $image_attr ).'/>';
					echo '</div>';
				}

				if( 'type-2' === $settings['content_type'] ) {
					echo '<div class="kfw-split-scroll-title-t2-wrap">';
				}

				/**
				 * Icon
				 */
					if( $settings['use_header_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
						if( $item['icon_type'] === 'icon' ) {
							$this->_render_icon( $item['icon'] );
						} else if( $item['icon_type'] === 'text' ) {
							$this->_render_text( $item['text'] );
						} else if( $item['icon_type'] === 'image' ) {
							$this->_render_img( $item['image'] );
						} else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
							$src = '';
							if( $item['icon_type'] === 'lordicon_media' ) {
								$src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
							} else if( $item['icon_type'] === 'lordicon_external' ) {
								$src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
							}

							if( !empty( $src ) ) {
								$lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

								$this->add_render_attribute( $lordicon, [
									'class'   => 'kfw-elementor-lordicon',
									'src'     => $src,
									'stroke'  => 45,
									'target'  => '#elementor-repeater-l-item-' . esc_attr( $item['_id'] ),
									'trigger' => 'click'
								]);

								/**
								 * Colors
								 */
									$colors = '';
									$colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
									$colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
									$colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
									if( !empty( $colors ) ) {
										$this->add_render_attribute( $lordicon, 'colors', $colors );
									}

								echo '<div class="kfw-split-scroll-title-icon-wrap kfw-split-scroll-title-lordicon-type">';
									echo '<span class="kfw-elementor-icon-wrap">';
										echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
									echo '</span>';
								echo '</div>';
							}
						}
					}

				/**
				 * Title
				*/
					$title     = trim( $item['title'] );
					$sub_title = trim( $item['sub_title'] );
					if( !empty( $title ) || !empty( $sub_title ) ) {
						echo '<div class="kfw-split-scroll-title-wrap">';
							if( !empty( $title ) ) {
								echo '<div class="kfw-split-scroll-title">';
									echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
								echo '</div>';
							}

							if( !empty( $sub_title ) ) {
								echo '<div class="kfw-split-scroll-sub-title">';
									echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
								echo '</div>';
							}

						echo '</div>';
					}

				if( 'type-2' === $settings['content_type'] ) {
					echo '</div>';
				}

				/**
				 * Content
				 */
					$item_src   = $item['source'];
					$l_con_item = $this->get_repeater_setting_key( 'l_con_item', 'items', $index );
					$this->add_render_attribute( $l_con_item, [
						'class'   => array_filter([
							'kfw-elementor-split-scroll-content-wrap',
							'kfw-elementor-split-scroll-content-'.$item_src.'-type',
						]),
					]);

					echo '<div '.$this->get_render_attribute_string( $l_con_item ).'>';
						if( $item_src === 'editor' ) {
							echo $this->parse_text_editor( $item['editor'] );
						} else if( $item_src === 'template' && ( $item['template'] != '0' && !empty( $item['template'] ) ) ) {
							echo $this->_generate_template_content( $item['template'] );
						}
					echo '</div>';
			echo '</div>';

		endforeach;
	echo '</div>';

	/**
	 * Right
	 */
	echo '<div class="kfw-elementor-split-scroll-items-wrap kfw-elementor-split-scroll-r-items-wrap">';
		foreach( $items as $index => $item ):
			$r_item = $this->get_repeater_setting_key( 'r_item', 'items', $index );
			$this->add_render_attribute( $r_item, [
				'class'   => array_filter([
					'elementor-repeater-item-' . esc_attr( $item['_id'] ),
					'kfw-elementor-split-scroll-item',
					'kfw-elementor-split-scroll-r-item',
					'kfw-elementor-split-scroll-img-item',
				]),
			]);

			echo '<div '.$this->get_render_attribute_string( $r_item ).'></div>';
		endforeach;
	echo '</div>';

echo '</div>';