<?php
/**
 * Widget Template : Tabs
 */

$settings = $this->get_settings();
$items    = $settings['items'];

if( empty( $items ) ) {
    return;
}

/**
 * Setting Up Default Tab
 */
    $default_tab = 'elementor-repeater-item-'.$items[0]['_id'];
    if( $settings['active_tab'] > 0 ) {
        $id = $settings['active_tab'];
        $id--;

        $default_tab = isset($items[$id]) ? 'elementor-repeater-item-'.$items[$id]['_id'] : $default_tab;
    }

$this->add_render_attribute( 'main', [
    'id'               => 'kfw-ele-widget-tabs-'.esc_attr( $this->get_id() ),
    'class'            => [
        'kfw-ele-widget-tabs-main',
        'kfw-tab-type',
        'kfw-tab-'.$settings['tab_type'],
        'kfw-ele-tabs-icon-position-'. $settings['icon_position']
    ],
    'data-default-tab' => $default_tab
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    /**
     * Header
     */
    echo '<div class="kfw-ele-widget-tabs-header-wrapper">';

        if( 'type-3' === $settings['tab_type'] ) {
            echo '<div class="kfw-ele-widget-tabs-type-3-header">';
        }

        foreach( $items as $index => $item ):
            $tab_item = $this->get_repeater_setting_key( 'tab_item', 'items', $index );

            $this->add_render_attribute( $tab_item, [
                'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'id'      => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                'class'   => array_filter([
                    'elementor-repeater-item-tab-header-' . esc_attr( $item['_id'] ),
                    'kfw-elementor-tabs-tab',
                ]),
            ]);

            echo '<div '.$this->get_render_attribute_string( $tab_item ).'>';
                /**
                 * Icon
                 */
                if( $settings['use_tabs_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
                    if( $item['icon_type'] === 'icon' ) {
                        $this->_render_icon( $item['icon'] );
                    } else if( $item['icon_type'] === 'image' ) {
                        $this->_render_img( $item['image'] );
                    } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                        $src = '';
                        if( $item['icon_type'] === 'lordicon_media' ) {
                            $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                        } else if( $item['icon_type'] === 'lordicon_external' ) {
                            $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                        }

                        if( !empty( $src ) ) {
                            $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                            $this->add_render_attribute( $lordicon, [
                                'class'   => 'kfw-elementor-lordicon',
                                'src'     => $src,
                                'stroke'  => 45,
                                'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                'trigger' => 'click'
                            ]);

                            /**
                             * Colors
                             */
                                $colors = '';
                                $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                if( !empty( $colors ) ) {
                                    $this->add_render_attribute( $lordicon, 'colors', $colors );
                                }

                            echo '<div class="kfw-ele-widget-tabs-icon-wrap kfw-ele-widget-tabs-icon-lordicon-type">';
                                echo '<span class="kfw-elementor-icon-wrap">';
                                    echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                echo '</span>';
                            echo '</div>';
                        }
                    }
                }

                $title     = trim( $item['title'] );
                $sub_title = trim( $item['sub_title'] );

                if( !empty( $title ) || !empty( $sub_title ) ) {

                    echo '<div class="kfw-elementor-tabs-tab-title-wrap">';

                        /**
                         * Title
                         */
                        if( !empty( $title ) ) {
                            echo '<div class="kfw-elementor-tabs-tab-title">';
                                echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
                            echo '</div>';
                        }

                        /**
                         * Sub Title
                         */
                        if( !empty( $sub_title ) ) {
                            echo '<div class="kfw-elementor-tabs-tab-sub-title">';
                                echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
                            echo '</div>';
                        }

                    echo '</div>';
                }

            echo '</div>';
        endforeach;

        if( 'type-3' === $settings['tab_type'] ) {
            echo '</div>';
        }

    echo '</div>';

    /**
     * Content
     */
    echo '<div class="kfw-ele-widget-tabs-content-wrapper">';
        foreach( $items as $index => $item ):

            /**
             * Mobile Title
             */
                $mobile_tab_item = $this->get_repeater_setting_key( 'mobile_tab_item', 'items', $index );
                $this->add_render_attribute( $mobile_tab_item, [
                    'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    'class'   => array_filter([
                        'elementor-repeater-item-tab-header-' . esc_attr( $item['_id'] ),
                        'kfw-elementor-tabs-tab',
                        'kfw-elementor-tabs-mobile-tab',
                    ]),
                ]);

                echo '<div '.$this->get_render_attribute_string( $mobile_tab_item ).'>';
                    /**
                     * Icon
                     */
                    if( $settings['use_tabs_icon'] === 'yes' && $item['icon_type'] !== 'blank' ) {
                        if( $item['icon_type'] === 'icon' ) {
                            $this->_render_icon( $item['icon'] );
                        } else if( $item['icon_type'] === 'image' ) {
                            $this->_render_img( $item['image'] );
                        } else if( $item['icon_type'] === 'lordicon_media' || $item['icon_type'] === 'lordicon_external' ) {
                            $src = '';
                            if( $item['icon_type'] === 'lordicon_media' ) {
                                $src = !empty( $item['lordicon_media']['url'] ) ? $item['lordicon_media']['url'] : '';
                            } else if( $item['icon_type'] === 'lordicon_external' ) {
                                $src = !empty( $item['lordicon_external']['url'] ) ? $item['lordicon_external']['url'] : '';
                            }

                            if( !empty( $src ) ) {
                                $lordicon = $this->get_repeater_setting_key( 'lordicon', 'items', $index );

                                $this->add_render_attribute( $lordicon, [
                                    'class'   => 'kfw-elementor-lordicon',
                                    'src'     => $src,
                                    'stroke'  => 45,
                                    'target'  => '#elementor-repeater-item-' . esc_attr( $item['_id'] ),
                                    'trigger' => 'click'
                                ]);

                                /**
                                 * Colors
                                 */
                                    $colors = '';
                                    $colors .= !empty( $settings['lordicon_primary_color'] ) ? 'primary:'.$settings['lordicon_primary_color'].',': '';
                                    $colors .= !empty( $settings['lordicon_secondary_color'] ) ? 'secondary:'.$settings['lordicon_secondary_color'].',': '';
                                    $colors .= !empty( $settings['lordicon_tertiary_color'] ) ? 'tertiary:'.$settings['lordicon_tertiary_color'].',': '';
                                    if( !empty( $colors ) ) {
                                        $this->add_render_attribute( $lordicon, 'colors', $colors );
                                    }

                                echo '<div class="kfw-ele-widget-tabs-icon-wrap kfw-ele-widget-tabs-icon-lordicon-type">';
                                    echo '<span class="kfw-elementor-icon-wrap">';
                                        echo '<lord-icon '. $this->get_render_attribute_string( $lordicon ) .'></lord-icon>';
                                    echo '</span>';
                                echo '</div>';
                            }
                        }
                    }

                    $title     = trim( $item['title'] );
                    $sub_title = trim( $item['sub_title'] );

                    if( !empty( $title ) || !empty( $sub_title ) ) {

                        echo '<div class="kfw-elementor-tabs-tab-title-wrap">';
    
                            /**
                             * Title
                             */
                            if( !empty( $title ) ) {
                                echo '<div class="kfw-elementor-tabs-tab-title">';
                                    echo wp_kses( $title, [ 'strong' => '', 'br' => '' ] );
                                echo '</div>';
                            }
    
                            /**
                             * Sub Title
                             */
                            if( !empty( $sub_title ) ) {
                                echo '<div class="kfw-elementor-tabs-tab-sub-title">';
                                    echo wp_kses( $sub_title, [ 'strong' => '', 'br' => '' ] );
                                echo '</div>';
                            }
    
                        echo '</div>';
                    }

                echo '</div>';

            /**
             * Content
             */
                $tab_src  = $item['source'];
                $tab_content = $this->get_repeater_setting_key( 'tab_content', 'items', $index );

                $this->add_render_attribute( $tab_content, [
                    'data-id' => 'elementor-repeater-item-' . esc_attr( $item['_id'] ),
                    'hidden'  => 'hidden',
                    'class'   => array_filter([
                        'elementor-repeater-item-tab-content-' . esc_attr( $item['_id'] ),
                        'elementor-repeater-item-tab-content-' . esc_attr( $tab_src ) .'-type',
                        'kfw-elementor-tabs-content',
                    ]),
                ]);

                echo '<div '.$this->get_render_attribute_string( $tab_content ).'>';
                    if( $tab_src === 'editor' ) {
                        echo $this->parse_text_editor( $item['editor'] );
                    } else if( $tab_src === 'template' && ( $item['template'] != '0' && !empty( $item['template'] ) ) ) {
                        echo $this->_generate_template_content( $item['template'] );
                    }
                echo '</div>';
        endforeach;
    echo '</div>';

echo '</div>';