<?php
/**
 * Widget Template : Theme Button
 */

$settings = $this->get_settings();

$this->add_render_attribute( 'main', [
	'id'    => 'kfw-ele-widget-theme-button-'.esc_attr( $this->get_id() ),
	'class' => [ 'kfw-ele-widget-theme-button-main' ],
]);

echo '<div '.$this->get_render_attribute_string( 'main' ).'>';

    $this->add_render_attribute( 'btn-wrap', [
        'class' => array_filter([
            'kfw-ele-widget-button-wrap',
            !empty( trim( $settings['btn_text'] ) ) ? 'kfw-ele-widget-button-has-txt' : ''
        ])
    ]);
    echo '<div '.$this->get_render_attribute_string( 'btn-wrap' ).'>';

        /**
         * Anchor
         */
        $this->add_render_attribute( 'btn', [
            'class' => array_filter([ 'kfw-ele-widget-theme-button' ]),
        ]);

            $link = array_filter( $settings['btn_link'] );
            if ( ! empty( $link['url'] ) ) {

                $this->add_render_attribute( 'btn', 'href', esc_url( $link['url'] ) );

                if ( ! empty( $link['is_external'] ) ) {
                    $this->add_render_attribute( 'btn', 'target', '_blank' );
                }

                if ( ! empty( $link['nofollow'] ) ) {
                    $this->add_render_attribute( 'btn', 'rel', 'nofollow' );
                }
            }

            echo '<a '.$this->get_render_attribute_string( 'btn' ).'>';
                $this->_render_icon( $settings['btn_icon'] );

                if( !empty( trim( $settings['btn_text'] ) ) ) {
                    printf( '<span class="kfw-elementor-button-text">%s</span>', esc_html( $settings['btn_text'] ) );
                }
            echo '</a>';

    echo '</div>';

echo '</div>';