<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Plugin as KFEl;
use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Group_Control_Image_Size as KFGCIS;

use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

use \Elementor\Utils as KFUtils;

class KFW_Brands_Grid extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-brands-grid';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Brands Grid', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_core_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-container-grid kfw-brands-grid';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'brand', 'brands', 'client', 'clients' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/brands-grid';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_style( 'kfw-brands-grid',
			KFE_CONST_URL . 'libraries/elementor/assets/css/brands-grid' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'kfw-brands-grid' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
		$this->_register_settings_section();
		$this->_register_item_style_section();
    }

    public function _register_items_section() {
		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Brand Items', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
            $this->add_control( 'items', [
				'type'        => KFCM::REPEATER,
				'fields'      => [
                    [
                        'name'        => 'name',
                        'label'       => esc_html__( 'Name', 'onnat-extra' ),
                        'type'        => KFCM::TEXT,
                        'label_block' => true,
                        'dynamic'     => [ 'active' => true ],
                        'default'     => esc_html__( 'Brand Name', 'onnat-extra' ),
                    ],
                    [
                        'name'         => 'enable_link',
                        'label'        => esc_html__( 'Enable Link', 'onnat-extra' ),
                        'type'         => KFCM::SWITCHER,
                        'dynamic'      => [ 'active' => true ],
                        'return_value' => 'yes',
                    ],
                    [
                        'name'          => 'link',
                        'label'         => esc_html__( 'Link', 'onnat-extra' ),
                        'type'          => KFCM::URL,
                        'placeholder'   => esc_html__( 'https://kinforce.net', 'onnat-extra' ),
                        'dynamic'       => [
                            'active' => true,
                        ],
                        'show_external' => true,
                        'condition'     => [
                            'enable_link' => 'yes'
                        ],
                    ],
                    [
                        'name'    => 'image',
                        'label'   => esc_html__( 'Image', 'onnat-extra' ),
                        'type'    => KFCM::MEDIA,
                        'default' => [
                            'url' => KFUtils::get_placeholder_image_src(),
                            'id'  => -1
                        ],
                        'dynamic' => [
                            'active' => true,
                        ],
                    ],
					[
						'name'    => 'hover',
						'label'   => esc_html__( 'Hover Effect', 'onnat-extra' ),
						'type'    => KFCM::CHOOSE,
						'options' => [
							'none'  => [
								'title' => esc_html__('None', 'onnat-extra'),
								'icon'  => ''
							],
							'gray'  => [
								'title' => esc_html__('Gray Image', 'onnat-extra'),
								'icon'  => ' eicon-preview-medium'
							],
							'image' => [
								'title' => esc_html__('Alternative Image', 'onnat-extra'),
								'icon' => 'eicon-image-rollover'
							],
						],
						'dynamic' => [ 'active' => true, ],
						'default' => 'none',
						'toggle'  => false,
					],
                    [
                        'name'      => 'himage',
                        'label'     => esc_html__( 'Hover Image', 'onnat-extra' ),
                        'type'      => KFCM::MEDIA,
                        'condition' => [ 'hover' => 'image'],
                        'default'   => [
                            'url' => KFUtils::get_placeholder_image_src(),
                            'id'  => -1
                        ],
                        'dynamic'   => [
                            'active' => true,
                        ],
                    ],
				],
				'title_field' => '{{{ name }}}',
				'default'     => [
					[
						'name'  => 'Client 1',
						'image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-1.svg'
						]
					],
					[
						'name'  => 'Client 2',
						'image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-2.svg'
						]
					],
					[
						'name'  => 'Client 3',
						'image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-3.svg'
						]
					],
					[
						'name'  => 'Client 4',
						'image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-4.svg'
						]
					],
					[
						'name'  => 'Client 5',
						'image' => [
							'url' => KFE_CONST_URL .'libraries/elementor/assets/images/image-placeholder-5.svg'
						]
					],
				]
            ]);
			$this->add_control( 'hr_0', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_group_control( KFGCIS::get_type(), [
				'name'    => 'image_size',
				'default' => 'medium',
			]);
			$this->add_responsive_control( 'img_max_size', [
				'label'      => esc_html__('Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'size_units' => ['px'],
				'range'      => [
					'px' => [
						'min' => 5,
						'max' => 500,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} img.kfw-ele-widget-brands-grid-image' => 'max-width:{{SIZE}}px;'
				],
			]);
		$this->end_controls_section();
    }

	public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_responsive_control('cols', [
				'label'          => esc_html__( 'Columns', 'onnat-extra' ),
				'type'           => KFCM::CHOOSE,
				'options'        => [
					'1' => [ 'title' => esc_html__('1 Column', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-icon' ],
					'2' => [ 'title' => esc_html__('2 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-2-icon' ],
					'3' => [ 'title' => esc_html__('3 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-3-icon' ],
					'4' => [ 'title' => esc_html__('4 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-4-icon' ],
					'5' => [ 'title' => esc_html__('5 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-5-icon' ],
					'6' => [ 'title' => esc_html__('6 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-6-icon' ],
				],
				'devices'        => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
				'default'        => '3',
				'tablet_default' => '2',
				'mobile_default' => '1',
				'selectors'      => [
					'{{WRAPPER}} .kfw-ele-widget-brands-grid-main' => 'grid-template-columns: repeat({{SIZE}}, minmax(0, 1fr));',
				],
				'toggle'         => false
			]);
			$this->add_responsive_control('col_gap',[
				'label'     => esc_html__( 'Column Gap', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'devices'   => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
				'default'   => [
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-brands-grid-main' => 'grid-column-gap: {{SIZE}}{{UNIT}};',
				],
			]);
			$this->add_responsive_control('row_gap',[
				'label'     => esc_html__( 'Row Gap', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'devices'   => [ 'widescreen', 'desktop', 'laptop', 'tablet', 'tablet_extra' ],
				'default'   => [ 'size' => 20,],
				'selectors' => [
					'{{WRAPPER}} .kfw-ele-widget-brands-grid-main' => 'grid-row-gap: {{SIZE}}{{UNIT}};',
				],
			]);
		$this->end_controls_section();
	}

	public function _register_item_style_section() {
		$this->start_controls_section( 'section_item_style',[
			'label' => esc_html__( 'Items', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->start_controls_tabs( 'tabs_item_style' );
				$this->start_controls_tab( 'tabs_item_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'items_bg',
						'selector' => '{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper',
					]);
					$this->add_control( 'hr_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'items_padding',[
						'label'      => esc_html__('Padding', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_responsive_control( 'items_margin',[
						'label'      => esc_html__('Margin', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_2', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'     => 'items_border',
						'selector' => '{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper'
					]);
					$this->add_control( 'hr_3', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'items_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						]
					]);
					$this->add_control( 'hr_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'items_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_item_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'items_h_bg',
						'selector' => '{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper:hover',
					]);
					$this->add_control('items_h_border_color',[
						'label'     => esc_html__( 'Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => [
							'items_border_border!' => '',
						],
						'selectors' => [
							'{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper:hover' => 'border-color: {{VALUE}};',
						],
					]);
					$this->add_responsive_control( 'items_h_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						]
					]);
					$this->add_group_control(KFGCBS::get_type(),[
						'name'     => 'item_hover_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-ele-widget-brands-grid-image-wrapper:hover',
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	/**
	 * Get attachment image src.
	 */
	public static function _get_image_src( $attachment_id, $image_size_key, array $settings ) {
        return KFGCIS::get_attachment_image_src( $attachment_id, $image_size_key, $settings );
	}

	public static function _get_image_html( $settings ) {
		return KFGCIS::get_attachment_image_html( $settings );
	}

	public function _get_image_title( $attachment ) {
		if ( empty( $attachment['id'] ) ) {
			return '';
		}

		return get_the_title( $attachment['id'] );
	}

	public function _get_image_alt( $instance ) {
		if ( empty( $instance['id'] ) ) {
			// For `Insert From URL` images.
			return isset( $instance['alt'] ) ? trim( strip_tags( $instance['alt'] ) ) : '';
		}

		$attachment_id = $instance['id'];
		if ( ! $attachment_id ) {
			return '';
		}

		$attachment = get_post( $attachment_id );
		if ( ! $attachment ) {
			return '';
		}

		$alt = get_post_meta( $attachment_id, '_wp_attachment_image_alt', true );
		if ( ! $alt ) {
			$alt = $attachment->post_excerpt;
			if ( ! $alt ) {
				$alt = $attachment->post_title;
			}
		}
		return trim( strip_tags( $alt ) );
	}

    public function _is_editor_mode() {
        $preview = KFEl::instance()->preview->is_preview_mode();
        $editor  = KFEl::instance()->editor->is_edit_mode();

        return ( $preview || $editor ) ? true : false;
    }

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-brands-grid");
		include $render;
    }

}