<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

use \Elementor\Widget_Base as WB;
use \Elementor\Controls_Manager as KFCM;
use \Elementor\Icons_Manager as KFIM;

use \Elementor\Group_Control_Typography as KFGCT;
use \Elementor\Group_Control_Text_Shadow as KFGCTS;
use \Elementor\Group_Control_Text_Stroke as KFGCTST;
use \Elementor\Group_Control_Background as KFGCBG;
use \Elementor\Group_Control_Border as KFGCBR;
use \Elementor\Group_Control_Box_Shadow as KFGCBS;

class KFW_CPT_Team_Member_Carousel extends WB {

	/**
	 * Get element name.
	 *
	 * Retrieve the element name.
	 *
	 * @return string The name.
	 */
	public function get_name() {
        return 'kfw-cpt-team-member-carousel';
    }

	/**
	 * Get element title.
	 *
	 * Retrieve the element title.
	 *
	 * @return string Element title.
	 */
	public function get_title() {
		return esc_html__('Team Member Carousel', 'onnat-extra');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the widget categories.
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ '_kfw_theme_widgets' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve the widget icon.
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'kfw-badge eicon-nested-carousel kfw-cpt-team-member-carousel';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the widget keywords.
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'kfw', 'kin', 'team', 'member', 'carousel' ];
	}

	/**
	 * Get widget help url.
	 *
	 * Retrieve the widget help url.
	 *
	 * @return string Widget help url.
	 */
	public function get_custom_help_url() {
        return KFE_CONST_THEME_DOC . 'elementor-custom-widgets/cpt-team-member-carousel';
    }

	/**
	 * Get HTML wrapper class.
     *
	 * Retrieve the widget container class.
     *
     * @return string Widget container css classes.
	 */
	public function get_html_wrapper_class() {
        $name = $this->get_name();

		return sprintf( 'kfw-ele-%s elementor-widget-%s', $name, $name );
	}

	/**
	 * Widget base constructor.
	 *
	 * Initializing the widget base class.
	 */
	public function __construct( $data = [], $args = null ) {
        parent::__construct( $data, $args );

		wp_register_script( 'kfw-cpt-team-member-carousel',
			KFE_CONST_URL . 'libraries/elementor/assets/js/cpt-team-member-carousel' . KFE_CONST_DEBUG_SUFFIX . '.js',
			[ 'jquery', 'elementor-frontend' ],
			KFE_CONST_VERSION,
			true
		);

		wp_register_style( 'kfw-cpt-team-member-carousel',
			KFE_CONST_URL . 'libraries/elementor/assets/css/cpt-team-member-carousel' . KFE_CONST_DEBUG_SUFFIX . '.css',
			[],
			KFE_CONST_VERSION
		);
    }

	/**
	 * Get style dependencies.
	 *
	 * Retrieve the list of style dependencies the element requires.
	 *
	 * @return array Element styles dependencies.
	 */
	public function get_style_depends() {
		return [ 'swiper', 'kfw-cpt-team-member-carousel' ];
	}

	/**
	 * Get script dependencies.
	 *
	 * Retrieve the list of script dependencies the element requires.
	 *
	 * @return array Element scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'kfw-cpt-team-member-carousel' ];
	}

	/**
	 * Register controls.
	 *
	 * Used to add new controls to any element type.
	 */
	protected function register_controls() {
		$this->_register_items_section();
		$this->_register_social_links_section();
		$this->_register_settings_section();
		$this->_register_image_style_section();
		$this->_register_content_wrap_style_section();
		$this->_register_title_style_section();
		$this->_register_role_style_section();
		$this->_register_social_style_section();
		$this->_register_nav_style_section();
		$this->_register_dot_style_section();
    }

    public function _register_items_section() {
		$members = $this->_team_members();

		$this->start_controls_section( 'section_items', [
			'label' => esc_html__( 'Team Members', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_control( 'items', [
				'type'        => KFCM::REPEATER,
				'fields'      => [
					[
						'name'        => 'member',
						'label'       => esc_html__( 'Member', 'onnat-extra' ),
						'type'        => KFCM::SELECT2,
						'multiple'    => false,
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
						'options'     => $members,
						'default'     => ''
					]
				],
				'title_field' => "<# let labels = ".json_encode( $members )."; let label = labels[member]; #>{{{ label }}}",
				'default'     => [],
			]);
		$this->end_controls_section();
	}

	public function _register_social_links_section() {
		$social_links = [
			'facebook'  => esc_html__( 'Facebook', 'onnat-extra' ),
			'linkedin'  => esc_html__( 'LinkedIn', 'onnat-extra' ),
			'twitter'   => esc_html__( 'Twitter', 'onnat-extra' ),
			'youtube'   => esc_html__( 'YouTube', 'onnat-extra' ),
			'instagram' => esc_html__( 'Instagram', 'onnat-extra' ),
			'pinterest' => esc_html__( 'Pinterest', 'onnat-extra' ),
			'flickr'    => esc_html__( 'Flickr', 'onnat-extra' ),
			'xing'      => esc_html__( 'Xing', 'onnat-extra' ),
		];

		$this->start_controls_section( 'section_links', [
			'label' => esc_html__( 'Social Links', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_control( 'socials', [
				'type'         => KFCM::REPEATER,
				'item_actions' => [
					'add' => false,
					'duplicate' => false,
					'remove'    => false,
					'sort'      => true,
				],
				'fields'       => [
					[
						'name'        => 'social',
						'label'       => '',
						'type'        => KFCM::SELECT,
						'classes'     => 'elementor-control-type-hidden',
						'label_block' => true,
						'dynamic'     => [ 'active' => true ],
						'options'     => $social_links,
						'default'     => '',
					],
					[
						'name'         => 'status',
						'label'        => esc_html__( 'Enable it?', 'onnat-extra' ),
						'type'         => KFCM::SWITCHER,
						'dynamic'      => [ 'active' => true ],
						'return_value' => 'yes',
						'default'      => 'yes',
					],
				],
				'title_field'  => "<# let labels = ".json_encode( $social_links )."; let label = labels[social]; let s = ( status === 'yes' ) ? 'Enabled' : 'Disabled'; #> {{{ label }}} - {{{ s }}}",
				'default'      => [
					[ 'social' => 'facebook', 'status' => 'yes' ],
					[ 'social' => 'linkedin', 'status' => 'yes' ],
					[ 'social' => 'twitter', 'status' => 'yes' ],
					[ 'social' => 'youtube', 'status' => 'no' ],
					[ 'social' => 'instagram', 'status' => 'no' ],
					[ 'social' => 'pinterest', 'status' => 'no' ],
					[ 'social' => 'flickr', 'status' => 'no' ],
					[ 'social' => 'xing', 'status' => 'no' ],
				],
			]);
		$this->end_controls_section();
	}

	public function _register_settings_section() {
		$this->start_controls_section( 'section_settings', [
			'label' => esc_html__( 'Settings', 'onnat-extra' ),
			'tab'   => KFCM::TAB_CONTENT,
		]);
			$this->add_control('layout', [
				'label'   => esc_html__( 'Layout', 'onnat-extra' ),
				'type'    => KFCM::CHOOSE,
				'options' => [
					'kinfw-team-member-grid-style-1' => [
						'title' => esc_html__('Grid Style 1', 'onnat-extra' ),
						'icon'  => 'eicon-gallery-grid'
					],
					'kinfw-team-member-grid-style-2' => [
						'title' => esc_html__('Grid Style 2', 'onnat-extra' ),
						'icon'  => 'eicon-posts-grid'
					],
					'kinfw-team-member-grid-style-3' => [
						'title' => esc_html__('Grid Style 3', 'onnat-extra' ),
						'icon'  => 'eicon-person'
					],
					'kinfw-team-member-grid-style-4' => [
						'title' => esc_html__('Grid Style 4', 'onnat-extra' ),
						'icon'  => 'eicon-hypster'
					],
					'kinfw-team-member-grid-style-5' => [
						'title' => esc_html__('Grid Style 5', 'onnat-extra' ),
						'icon'  => 'eicon-user-circle-o'
					],					
				],
				'default' => 'kinfw-team-member-grid-style-4',
				'toggle'  => false
			]);
			$this->add_responsive_control('style-4-min-height',[
				'label'     => esc_html__( 'Min Height', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'     => [
					'px' => [
						'min'  => 100,
						'max'  => 1000,
						'step' => 10,
					]
				],				
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-4' => 'min-height:{{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-4'
				],
			]);			
			$this->add_responsive_control('cols', [
				'label'              => esc_html__( 'Columns', 'onnat-extra' ),
				'type'               => KFCM::CHOOSE,
				'toggle'             => false,
				'frontend_available' => true,
				'desktop_default'    => 4,
				'tablet_default'     => 3,
				'mobile_default'     => 1,
				'options'            => [
					'1' => [ 'title' => esc_html__('1 Column', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-icon' ],
					'2' => [ 'title' => esc_html__('2 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-2-icon' ],
					'3' => [ 'title' => esc_html__('3 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-3-icon' ],
					'4' => [ 'title' => esc_html__('4 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-4-icon' ],
					'5' => [ 'title' => esc_html__('5 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-5-icon' ],
					'6' => [ 'title' => esc_html__('6 Columns', 'onnat-extra'), 'icon' => 'kfw-ctrl-icon kfw-ctrl-numeric-6-icon' ],
				],
			]);
			$this->add_responsive_control('col_gap',[
				'label'              => esc_html__( 'Item Gap', 'onnat-extra' ),
				'type'               => KFCM::SLIDER,
				'frontend_available' => true,
				'default'            => [
					'size' => 20,
				],
				'range'              => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
			]);
			$this->add_responsive_control('slide_to_scroll',[
				'label'              => esc_html__( 'Slides To Scroll', 'onnat-extra' ),
				'type'               => KFCM::NUMBER,
				'min'                => 1,
				'max'                => 20,
				'step'               => 1,
				'default'            => 1,
				'frontend_available' => true,
			]);
			$this->add_control( 'loop', [
				'label'              => esc_html__( 'Enable Loop?', 'onnat-extra' ),
				'type'               => KFCM::SWITCHER,
				'return_value'       => 'yes',
				'default'            => 'yes',
				'frontend_available' => true,
            ]);
			$this->add_control( 'hr_1', [
				'type' => KFCM::DIVIDER,
			]);
				$this->add_control('autoplay_settings_heading',[
					'label' => esc_html__( 'Autoplay Settings', 'onnat-extra' ),
					'type'  => KFCM::HEADING,
				]);
				$this->add_control('autoplay', [
					'label'              => esc_html__( 'Enable Autoplay?', 'onnat-extra' ),
					'type'               => KFCM::SWITCHER,
					'return_value'       => 'yes',
					'frontend_available' => true,
				]);
				$this->add_control('autoplay_speed',[
					'label'              => esc_html__('Autoplay Speed (ms)', 'onnat-extra' ),
					'type'               => KFCM::SLIDER,
					'frontend_available' => true,
					'size_units'         => [],
					'range'              => [
						'' => [
							'min'  => 500,
							'max'  => 15000,
							'step' => 100
						]
					],
					'default'    => [
						'unit' => '',
						'size' => 1000
					],
					'condition'  => [
						'autoplay' => 'yes'
					],
				]);
				$this->add_control( 'pause', [
					'label'              => esc_html__( 'Pause on Hover?', 'onnat-extra' ),
					'type'               => KFCM::SWITCHER,
					'return_value'       => 'yes',
					'default'            => 'yes',
					'frontend_available' => true,
					'condition'          => [
						'autoplay' => 'yes'
					],
				]);
				$this->add_control( 'pause_on_interaction', [
					'label'              => esc_html__( 'Pause on Interaction?', 'onnat-extra' ),
					'type'               => KFCM::SWITCHER,
					'return_value'       => 'yes',
					'default'            => 'yes',
					'frontend_available' => true,
					'condition'          => [
						'autoplay' => 'yes'
					],
				]);
			$this->add_control( 'hr_2', [
				'type' => KFCM::DIVIDER,
			]);
				$this->add_control( 'nav_settings_heading',[
					'label' => esc_html__( 'Navigation Settings', 'onnat-extra' ),
					'type'  => KFCM::HEADING,
				]);
				$this->add_control( 'arrows', [
					'label'              => esc_html__( 'Enable Arrows?', 'onnat-extra' ),
					'type'               => KFCM::SWITCHER,
					'return_value'       => 'yes',
					'frontend_available' => true,
				]);
				$this->add_control( 'mobile_arrows', [
					'label'              => esc_html__( 'Remove Arrows on Mobile?', 'onnat-extra' ),
					'type'               => KFCM::SWITCHER,
					'return_value'       => 'yes',
					'frontend_available' => true,
					'condition'          => [
						'arrows' => 'yes'
					],
				]);
				$this->add_control( 'arrow_position', [
					'label'     => esc_html__( 'Position', 'onnat-extra' ),
					'type'      => KFCM::CHOOSE,
					'options'   => [
						'default'       => [
							'title' => esc_html__( 'Default', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-left'
						],
						'top-left'      => [
							'title' => esc_html__( 'Top Left', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-45'
						],
						'top-center'    => [
							'title' => esc_html__( 'Top Center', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-90'
						],
						'top-right'     => [
							'title' => esc_html__( 'Top Right', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-135'
						],
						'bottom-left'   => [
							'title' => esc_html__( 'Bottom Left', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-left kfw-ctrl-rotate-315'
						],
						'bottom-center' => [
							'title' => esc_html__( 'Bottom Center', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-right kfw-ctrl-rotate-90'
						],
						'bottom-right'  => [
							'title' => esc_html__( 'Bottom Right', 'onnat-extra' ),
							'icon'  => 'eicon-chevron-right kfw-ctrl-rotate-45'
						],
						'custom'        => [
							'title' => esc_html__( 'Custom', 'onnat-extra' ),
							'icon'  => 'eicon-map-pin'
						],
					],
					'default'   => 'bottom-center',
					'condition' => [
						'arrows' => 'yes'
					],
					'toggle'             => false,
					'frontend_available' => true,
				]);
				$this->add_control( 'custom_nav_d_color', [
					'label'     => esc_html__( 'Nav Disabled Color', 'onnat-extra' ),
					'type'      => KFCM::COLOR,
					'condition' => [
						'arrows'         => 'yes',
						'arrow_position' => 'custom'
					],
					'selectors' => [
						'.kfw-js-swiper-{{ID}}-nav-next, .kfw-js-swiper-{{ID}}-nav-prev'                                                   => 'cursor:pointer !important;',
						'.kfw-js-swiper-{{ID}}-nav-next.swiper-button-disabled, .kfw-js-swiper-{{ID}}-nav-prev.swiper-button-disabled'     => 'cursor: text !important;',
						'.kfw-js-swiper-{{ID}}-nav-next.swiper-button-disabled *, .kfw-js-swiper-{{ID}}-nav-prev.swiper-button-disabled *' => 'color:{{VALUE}}; opacity:0.5;',
					]
				]);
				$this->add_control( 'left_arrow', [
					'label'     => esc_html__( 'Next Arrow', 'onnat-extra' ),
					'type'      => KFCM::ICONS,
					'default'   => [
						'value'   => 'fas fa-arrow-right',
						'library' => 'fa-solid',
					],
					'condition' => [
						'arrows'          => 'yes',
						'arrow_position!' => 'custom',
					],
				]);
				$this->add_control( 'right_arrow', [
					'label'     => esc_html__( 'Prev Arrow', 'onnat-extra' ),
					'type'      => KFCM::ICONS,
					'default'   => [
						'value'   => 'fas fa-arrow-left',
						'library' => 'fa-solid',
					],
					'condition' => [
						'arrows'          => 'yes',
						'arrow_position!' => 'custom',
					],
				]);
			$this->add_control( 'hr_3', [
				'type' => KFCM::DIVIDER,
			]);
			$this->add_control( 'dots', [
				'label'        => esc_html__( 'Show Dots?', 'onnat-extra' ),
				'type'         => KFCM::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
				'frontend_available' => true,
			]);
		$this->end_controls_section();
	}

	public function _register_image_style_section() {
		$this->start_controls_section( 'section_image_style', [
			'label' => esc_html__( 'Image', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control('style-4-image-max-height',[
				'label'     => esc_html__( 'Max Height', 'onnat-extra' ),
				'type'      => KFCM::SLIDER,
				'size_units' => [ 'px' ],
				'range'     => [
					'px' => [
						'min'  => 100,
						'max'  => 1000,
						'step' => 10,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-4 .kinfw-team-member-image-wrap' => 'max-height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-4:hover .kinfw-team-member-image-wrap' => 'max-height: 1000px;',
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-4'
				],
			]);		
			$this->add_group_control( KFGCBG::get_type(), [
				'name'     => 'image_bg',
				'label'    => esc_html__('Background', 'onnat-extra' ),
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .kinfw-team-member-image-wrap',
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'           => 'image_overlay_bg',
				'fields_options' => [
					'background' => [
						'label' => esc_html__('Background Overlay', 'onnat-extra' ),
					],
				],
				'types'          => [ 'classic', 'gradient' ],
				'exclude'        => [ 'image' ],
				'selector'       => '{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-5 .kinfw-team-member-image-wrap:before',
				'condition'      => [
					'layout' => 'kinfw-team-member-grid-style-5'
				],
			]);			
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'image_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-team-member-image-wrap',
			]);
			$this->add_responsive_control( 'image_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ '{{WRAPPER}} .kinfw-team-member-image-wrap, {{WRAPPER}} .kinfw-team-member-image-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'image_box_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-image-wrap',
			]);
            $this->add_responsive_control( 'image_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-image-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'image_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-image-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
	}

	public function _register_content_wrap_style_section() {
		$this->start_controls_section( 'section_wrap_style', [
			'label' => esc_html__( 'Info Wrapper', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'     => 'wrap_bg',
				'label'    => esc_html__('Background', 'onnat-extra' ),
				'types'    => [ 'classic', 'gradient' ],
				'exclude'  => [ 'image' ],
				'selector' => '{{WRAPPER}} .kinfw-team-member-content-wrap',
			]);
			$this->add_group_control( KFGCBG::get_type(), [
				'name'      => 'wrap_hover_bg',
				'fields_options' => [
					'background' => [ 'label' => _x( 'Hover Background Type', 'Border Control', 'onnat-extra' ) ],
				],
				'types'     => [ 'classic', 'gradient' ],
				'exclude'   => [ 'image' ],
				'selector'  => '{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-team-member-content-wrap:before',
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-3'
				],
			]);
			$this->add_group_control( KFGCBR::get_type(), [
				'name'           => 'wrap_border',
				'fields_options' => [
					'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
					'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
				],
				'selector'       => '{{WRAPPER}} .kinfw-team-member-content-wrap',
			]);
			$this->add_responsive_control( 'wrap_border_radius', [
				'label'      => esc_html__('Border Radius', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [ '{{WRAPPER}} .kinfw-team-member-content-wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ],
			]);
			$this->add_group_control( KFGCBS::get_type(), [
				'name'      => 'wrap_box_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap',
			]);
            $this->add_responsive_control( 'wrap_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'wrap_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
		$this->end_controls_section();
	}

	public function _register_title_style_section() {
		$this->start_controls_section( 'section_title_style', [
			'label' => esc_html__( 'Title', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'title_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a',
			]);
            $this->add_responsive_control( 'title_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'title_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'title_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-content-wrap h6 a' => 'color: {{VALUE}};'
				],
			]);
			$this->add_control( 'title_h_color', [
				'label'     => esc_html__('Hover Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item:hover .kinfw-team-member-content-wrap h6 a' => 'color: {{VALUE}};'
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-3'
				],
			]);
			$this->add_group_control( KFGCTS::get_type(), [
				'name'      => 'title_txt_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'      => 'title_txt_stroke',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap h6 a',
			]);
		$this->end_controls_section();
	}

	public function _register_role_style_section() {
		$this->start_controls_section( 'section_role_style', [
			'label' => esc_html__( 'Role', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_group_control(KFGCT::get_type(), [
				'name'      => 'role_typo',
				'label'     => esc_html__( 'Typography', 'onnat-extra' ),
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap p',
			]);
            $this->add_responsive_control( 'role_margin', [
                'label'      => esc_html__('Margin', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
            $this->add_responsive_control( 'role_padding', [
                'label'      => esc_html__('Padding', 'onnat-extra' ),
                'type'       => KFCM::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors'  => [
                    '{{WRAPPER}} .kinfw-team-member-content-wrap p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ]
            ]);
			$this->add_control( 'role_color', [
				'label'     => esc_html__('Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-content-wrap p a' => 'color: {{VALUE}};'
				],
			]);
			$this->add_control( 'role_h_color', [
				'label'     => esc_html__('Hover Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item:hover .kinfw-team-member-content-wrap p a' => 'color: {{VALUE}};'
				],
				'condition' => [
					'layout' => 'kinfw-team-member-grid-style-3'
				],
			]);			
			$this->add_group_control( KFGCTS::get_type(), [
				'name'      => 'role_txt_shadow',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap p',
			]);
			$this->add_group_control( KFGCTST::get_type(), [
				'name'      => 'role_txt_stroke',
				'selector'  => '{{WRAPPER}} .kinfw-team-member-content-wrap p',
			]);
		$this->end_controls_section();
	}

	public function _register_social_style_section() {
		$this->start_controls_section( 'section_social_style', [
			'label' => esc_html__( 'Social Share', 'onnat-extra' ),
			'tab'   => KFCM::TAB_STYLE,
		]);
			$this->add_responsive_control( 'icon_size', [
				'label'      => esc_html__('Icon Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'condition'  => [ 'layout!' => 'kinfw-team-member-grid-style-3' ],
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a:before' => 'font-size:{{SIZE}}{{UNIT}};'
				],
			]);
			$this->add_responsive_control( 'size', [
				'label'      => esc_html__('Size', 'onnat-extra' ),
				'type'       => KFCM::SLIDER,
				'condition'  => [ 'layout!' => 'kinfw-team-member-grid-style-3' ],
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a'                                              => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kinfw-social-links li a:before'                                       => 'line-height:{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .kfw-swiper.kinfw-team-member-grid-style-2-swiper'                     => 'padding-bottom: calc({{SIZE}}{{UNIT}}/2);',
					'{{WRAPPER}} .kfw-swiper.kinfw-team-member-grid-style-2-swiper .kinfw-social-links' => 'bottom: calc(-1 * ({{SIZE}}{{UNIT}}/2 + 5{{UNIT}}));',
				],
			]);
			$this->add_responsive_control('margin', [
				'label'      => esc_html__( 'Margin', 'onnat-extra' ),
				'type'       => KFCM::DIMENSIONS,
				'condition'  => [ 'layout!' => 'kinfw-team-member-grid-style-3' ],
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .kinfw-social-links li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
				],
			]);

			/**
			 * Style 3 : Settings
			 */
			$s3_condition = [
				'layout' => 'kinfw-team-member-grid-style-3',
			];
			$this->add_control('social_icon_handler_heading',[
				'label'     => esc_html__( 'ADDITIONAL STYLE 3 SETTINGS', 'onnat-extra' ),
				'type'      => KFCM::HEADING,
				'condition' => $s3_condition,
			]);
			$this->add_control( 'social_icon_handler_wrapper_color', [
				'label'     => esc_html__('Wrapper Background Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'condition' => $s3_condition,
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper' => 'background-color: {{VALUE}}; color: {{VALUE}};'
				],
			]);
			$this->start_controls_tabs( 'social_icon_handler_customize_tabs', [
				'condition' => $s3_condition,
			] );
				$this->start_controls_tab( 'social_icon_handler_normal_state', [
					'label'     => esc_html__( 'Handler Normal', 'onnat-extra' ),
					'condition' => $s3_condition,
				]);
					$this->add_control( 'social_icon_handler_icon_color', [
						'label'     => esc_html__('Icon Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => $s3_condition,
						'selectors' => [
							'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper .kinfw-social-icon .kinfw-icon' => 'color: {{VALUE}};'
						],
					]);
					$this->add_control( 'social_icon_handler_icon_bg_color', [
						'label'     => esc_html__('Icon BG Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => $s3_condition,
						'selectors' => [
							'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper .kinfw-social-icon' => 'background-color: {{VALUE}};'
						],
					]);
					$this->add_control( 'social_icon_handler_icon_border_color', [
						'label'     => esc_html__('Icon Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => $s3_condition,
						'selectors' => [
							'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-wrapper .kinfw-social-icon' => 'border-color: {{VALUE}};'
						],
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'social_icon_handler_hover_state', [
					'label'     => esc_html__( 'Handler Hover', 'onnat-extra' ),
					'condition' => $s3_condition,
				]);
					$this->add_control( 'social_icon_handler_icon_h_color', [
						'label'     => esc_html__('Icon Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => $s3_condition,
						'selectors' => [
							'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3:hover .kinfw-social-wrapper .kinfw-social-icon .kinfw-icon' => 'color: {{VALUE}};'
						],
					]);
					$this->add_control( 'social_icon_handler_icon_h_bg_color', [
						'label'     => esc_html__('Icon BG Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => $s3_condition,
						'selectors' => [
							'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3:hover .kinfw-social-wrapper .kinfw-social-icon' => 'background-color: {{VALUE}};'
						],
					]);
					$this->add_control( 'social_icon_handler_icon_h_border_color', [
						'label'     => esc_html__('Icon Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'condition' => $s3_condition,
						'selectors' => [
							'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3:hover .kinfw-social-wrapper .kinfw-social-icon' => 'border-color: {{VALUE}};'
						],
					]);					
				$this->end_controls_tab();					
			$this->end_controls_tabs();
			$this->add_control( 'social_icon_holder_wrapper_color', [
				'label'     => esc_html__('Social Icons Holder Background Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'condition' => $s3_condition,
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-links' => 'background-color: {{VALUE}};'
				],
			]);
			$this->add_control( 'social_icon_holder_border_color', [
				'label'     => esc_html__('Social Icons Holder Border Color', 'onnat-extra' ),
				'type'      => KFCM::COLOR,
				'condition' => $s3_condition,
				'separator' => 'after',
				'selectors' => [
					'{{WRAPPER}} .kinfw-team-member-item.kinfw-team-member-grid-style-3 .kinfw-social-links' => 'border-color: {{VALUE}};'
				],
			]);			
			/**
			 * Style 3 : Settings
			 */			

			$this->start_controls_tabs( 'customize_tabs' );
				$this->start_controls_tab( 'normal_state', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kinfw-social-links li a:before' => 'color: {{VALUE}};'
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'bg',
						'label'    => esc_html__('Background', 'onnat-extra' ),
						'types'    => [ 'classic', 'gradient' ],
						'exclude'  => [ 'image' ],
						'selector' => '{{WRAPPER}} .kinfw-social-links li a',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kinfw-social-links li a',
					]);
					$this->add_responsive_control( 'border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kinfw-social-links li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'hover_state', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'hover_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kinfw-social-links li a:hover:before' => 'color: {{VALUE}};'
						],
					]);
					$this->add_group_control( KFGCBG::get_type(), [
						'name'     => 'hover_bg',
						'label'    => esc_html__('Background', 'onnat-extra' ),
						'types'    => [ 'classic', 'gradient' ],
						'exclude'  => [ 'image' ],
						'selector' => '{{WRAPPER}} .kinfw-social-links li a:hover',
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'           => 'hover_border',
						'fields_options' => [
							'width' => [ 'label' => _x( 'Border Width', 'Border Control', 'onnat-extra' ) ],
							'color' => [ 'label' => _x( 'Border Color', 'Border Control', 'onnat-extra' ) ],
						],
						'selector'       => '{{WRAPPER}} .kinfw-social-links li a:hover',
					]);
					$this->add_responsive_control( 'hover_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kinfw-social-links li a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_nav_style_section() {
		$this->start_controls_section( 'section_nav_style',[
			'label'     => esc_html__( 'Navigation', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'arrows'          => 'yes',
				'arrow_position!' => 'custom'
			],
		]);
			$this->start_controls_tabs( 'tabs_nav_style', [
				'condition' => [
					'arrows'          => 'yes',
					'arrow_position!' => 'custom'
				],
			]);
				$this->start_controls_tab( 'tabs_nav_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-bg-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'hr_nav_style_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBR::get_type(), [
						'name'     => 'nav_border',
						'selector' => '{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap div'
					]);
					$this->add_control( 'hr_nav_style_3', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'nav_border_radius', [
						'label'      => esc_html__('Border Radius', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap div' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						]
					]);
					$this->add_control( 'hr_nav_style_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'nav_arrow_size',[
						'label'      => esc_html__('Size', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min' => 10,
								'max' => 200,
							],
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap div'                                                                                                                                                                                                              => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}; line-height:{{SIZE}}{{UNIT}};',
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-top-left, {{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-top-center, {{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-top-right'          => 'top:calc(({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2)*-1);',
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-bottom-left, {{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-bottom-center, {{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-bottom-right' => 'bottom:calc(({{SIZE}}{{UNIT}} + {{SIZE}}{{UNIT}}/2)*-1);',
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-default div.kfw-swiper-nav-prev'                                                                                                                                                     => 'margin-left:calc(({{SIZE}}{{UNIT}}/2)*-1);',
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap.kfw-cpt-team-member-carousel-nav-pos-default div.kfw-swiper-nav-next'                                                                                                                                                     => 'margin-right:calc(({{SIZE}}{{UNIT}}/2)*-1);',
						],
					]);
					$this->add_responsive_control( 'nav_arrow_icon_size', [
						'label'      => esc_html__('Icon Size', 'onnat-extra' ),
						'type'       => KFCM::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min' => 0,
								'max' => 200,
							],
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap .kfw-elementor-icon-wrap' => 'font-size: {{SIZE}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_nav_style_5', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap div'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_nav_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_h_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-hover-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_h_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-bg-hover-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_h_border_color', [
						'label'     => esc_html__('Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap div:hover' => 'border-color:{{VALUE}};',
						],
						'condition' => [
							'nav_border_border!' => '',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_h_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap div:hover'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_nav_disabled', [
					'label' => esc_html__( 'Disabled', 'onnat-extra' ),
				]);
					$this->add_control( 'nav_d_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-disabled-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_d_bg_color', [
						'label'     => esc_html__('Background Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}}' => '--kfw-swiper-nav-disabled-bg-color:{{VALUE}};',
						],
					]);
					$this->add_control( 'nav_d_border_color', [
						'label'     => esc_html__('Border Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap .swiper-button-disabled' => 'border-color:{{VALUE}};',
						],
						'condition' => [
							'nav_border_border!' => '',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'nav_d_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-cpt-team-member-carousel-nav-wrap .swiper-button-disabled'
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	public function _register_dot_style_section() {
		$this->start_controls_section( 'section_dot_style',[
			'label'     => esc_html__( 'Dot', 'onnat-extra' ),
			'tab'       => KFCM::TAB_STYLE,
			'condition' => [
				'dots' => 'yes'
			],
		]);
			$this->start_controls_tabs( 'tabs_dot_style', [
				'condition' => [
					'dots' => 'yes'
				],
			]);
				$this->start_controls_tab( 'tabs_dot_normal', [
					'label' => esc_html__( 'Normal', 'onnat-extra' ),
				]);
					$this->add_control( 'dot_color_settings', [
						'label'        => esc_html__('Colors', 'onnat-extra'),
						'type'         => KFCM::POPOVER_TOGGLE,
						'return_value' => 'yes',
					]);
					$this->start_popover();
						$this->add_control( 'dot_color', [
							'label'     => esc_html__('Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'selectors' => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'background:{{VALUE}};',
							],
						]);
						$this->add_control( 'active_dot_color', [
							'label'     => esc_html__('Active Color', 'onnat-extra' ),
							'type'      => KFCM::COLOR,
							'selectors' => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active, {{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active:hover' => 'background:{{VALUE}};',
							],
						]);
					$this->end_popover();
					$this->add_control( 'hr_dot_style_1', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_responsive_control( 'dot_padding',[
						'label'      => esc_html__('Padding', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'default'    => [
							'top'      => '',
							'right'    => '',
							'bottom'   => '',
							'left'     => '',
							'unit'     => 'px',
							'isLinked' => false
						],
						'selectors'  => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_responsive_control( 'dot_margin',[
						'label'      => esc_html__('Margin', 'onnat-extra' ),
						'type'       => KFCM::DIMENSIONS,
						'size_units' => [ 'px', 'em', '%' ],
						'selectors'  => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
						],
					]);
					$this->add_control( 'hr_dot_style_2', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_control( 'dot_size_settings_heading',[
						'label' => esc_html__( 'Size Settings', 'onnat-extra' ),
						'type'  => KFCM::HEADING,
					]);
						$this->add_responsive_control( 'dot_width',[
							'label'      => esc_html__('Width', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min' => 10,
									'max' => 100,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'width:{{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'width:calc({{SIZE}}{{UNIT}} + ({{SIZE}}{{UNIT}}/2));'
							],
						]);
						$this->add_responsive_control( 'dot_height',[
							'label'      => esc_html__('Height', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'size_units' => [ 'px' ],
							'range'      => [
								'px' => [
									'min' => 10,
									'max' => 100,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'height:{{SIZE}}{{UNIT}};',
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'height:calc({{SIZE}}{{UNIT}} + ({{SIZE}}{{UNIT}}/2));'
							],
						]);
						$this->add_responsive_control( 'dot_border_radius', [
							'label'      => esc_html__('Border Radius', 'onnat-extra' ),
							'type'       => KFCM::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'default'    => [
								'top'      => '',
								'right'    => '',
								'bottom'   => '',
								'left'     => '',
								'unit'     => 'px',
								'isLinked' => false
							],
							'selectors'  => [
								'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
							]
						]);
						$this->add_control( 'hr_dot_style_3', [
							'type' => KFCM::DIVIDER,
						]);
						$this->add_responsive_control( 'dot_space_between',[
							'label'      => esc_html__('Space Between', 'onnat-extra' ),
							'type'       => KFCM::SLIDER,
							'selectors'  => [
								'{{WRAPPER}}' => '--kfw-swiper-dots-space-between: {{SIZE}}{{UNIT}};',
							],
						]);
					$this->add_control( 'hr_dot_style_4', [
						'type' => KFCM::DIVIDER,
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'dot_box_shadow',
						'selector' => '{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet'
					]);
				$this->end_controls_tab();
				$this->start_controls_tab( 'tabs_dot_hover', [
					'label' => esc_html__( 'Hover', 'onnat-extra' ),
				]);
					$this->add_control( 'h_dot_color', [
						'label'     => esc_html__('Color', 'onnat-extra' ),
						'type'      => KFCM::COLOR,
						'selectors' => [
							'{{WRAPPER}} .kfw-swiper-pagination .swiper-pagination-bullet:hover' => 'background:{{VALUE}};',
						],
					]);
					$this->add_group_control( KFGCBS::get_type(), [
						'name'     => 'dot_h_box_shadow',
						'selector' => ''
					]);
				$this->end_controls_tab();
			$this->end_controls_tabs();
		$this->end_controls_section();
	}

	/**
	 * Generate setting json
	 */
	protected function _generate_setting_json( array $settings ) {
		$cols = [
			'widescreen'   => 5,
			'desktop'      => 4,
			'laptop'       => 3,
			'tablet'       => 2,
			'tablet_extra' => 2,
			'mobile'       => 1,
			'mobile_extra' => 1,
		];

		$options = [
			'autoHeight'     => true,
			'loop'           => $settings['loop'] === 'yes' ? true : false,
			'slidesPerView'  => 1,
			'slidesPerGroup' => 1,
			'spaceBetween'   => 20
		];

		/**
		 * Break Points
		 */
		$breakpoints            = \Elementor\Plugin::$instance->breakpoints->get_breakpoints();
		$options['breakpoints'] = [];

		$options['breakpoints'][1440] = [
			"device"         => 'desktop',
			'slidesPerView'  => ( isset($settings["cols"]) && !empty( $settings["cols"]) ) ? (int)$settings["cols"] : $cols['desktop'],
			'slidesPerGroup' => ( isset($settings["slide_to_scroll"]) && !empty( $settings["slide_to_scroll"] ) ) ? (int)$settings["slide_to_scroll"] : 1,
			'spaceBetween'   => ( isset($settings["col_gap"]["size"]) && !empty( $settings["col_gap"]["size"] ) ) ? (int)$settings["col_gap"]["size"] : 20,
		];

		foreach( $breakpoints as $breakpoint ) {
			$device = $breakpoint->get_label();
			$name   = $breakpoint->get_name();
			$value  = $breakpoint->get_value();

			if( 'widescreen' !== $name ) {
				$col_key    = "cols_".$name;
				$scroll_key = "slide_to_scroll_".$name;
				$gap_key    = "col_gap_".$name;

				if( isset( $settings[ $col_key ] ) ) {
					$options['breakpoints'][ $value ] = [
						"device"         => $device,
						"slidesPerView"  => ( isset( $settings[ $col_key ] ) && !empty( $settings[ $col_key ] ) ) ? (int) $settings[ $col_key ] : $cols[$name],
						"slidesPerGroup" => ( isset( $settings[ $scroll_key ] ) && !empty( $settings[ $scroll_key ] ) ) ? (int) $settings[ $scroll_key ] : 1,
						"spaceBetween"   => ( isset( $settings[ $gap_key ]['size'] ) && !empty( $settings[ $gap_key ]['size'] ) ) ? (int) $settings[ $gap_key ]['size'] : 20,
					];
				} else {
					$options['breakpoints'][ $value ] = [
						"device"         => $device,
						"slidesPerView"  => $cols[$name],
						"slidesPerGroup" => 1,
						"spaceBetween"   => 20,
					];
				}
			}
		}

		if( $settings['autoplay'] === 'yes' ) {
			$options['pauseOnHover']  = $settings['pause'] === 'yes' ? true : false;
			$options['autoplay']['delay'] = isset( $settings['autoplay_speed']['size'] ) ? $settings['autoplay_speed']['size'] : 1000;
		} else {
			$options['pauseOnHover']  = false;
		}

		if( $settings['arrows'] === 'yes' ) {
			$options['navigation']['nextEl'] = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-next';
			$options['navigation']['prevEl'] = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-nav-prev';
			$options['arrowPosition']        = $settings['arrow_position'];
			$options['hideArrowsOnMobile']   = $settings['mobile_arrows'] === 'yes' ? true : false;
		}

		if( $settings['dots'] === 'yes' ) {
			$options['pagination']['type']      = 'bullets';
			$options['pagination']['el']        = '.kfw-js-swiper-'.esc_attr( $this->get_id() ).'-pagination';
			$options['pagination']['clickable'] = true;
		}

		return wp_json_encode( $options );
	}

	public function _message( $message, $echo = true ) {
		$return = sprintf( '
			<div class="elementor-alert elementor-alert-info" role="alert">
				<span class="elementor-alert-description">%s</span>
			</div>',
			$message
		);

		if( $echo ) {
			echo $return;
			return;
		}

		return $return;
	}

	public function _render_icon( $icon , $echo = true ) {
		$icon = array_filter( $icon );

		if( !empty( $icon ) ) {
			echo '<span class="kfw-elementor-icon-wrap">';
				KFIM::render_icon( $icon, [ 'aria-hidden' => 'true' ] );
			echo '</span>';
		}
	}

	public function _team_members() {
		$result = [ esc_html__( '-- Select --', 'onnat-extra' ) ];

		$posts = get_posts([
			'post_type'      => 'kinfw-team-member',
			'post_status'    => 'publish',
			'posts_per_page' => -1
		]);

		if ( ! empty( $posts ) && ! is_wp_error( $posts ) ) {
			foreach ( $posts as $item ) {
				$result[ $item->ID ] = $item->post_title;
			}
		}

		return $result;
	}

	/**
	 * Render widget output on the frontend.
	 */
    protected function render() {
		$render = kf_extra_plugin_elementor()->get_template("kfw-cpt-team-member-carousel");
		include $render;
    }
}