export type FontflowOnnatId =
  | "angle-right"
  | "comments-dots-alt"
  | "comments-dots"
  | "cross"
  | "humburger"
  | "line-arrow-cross-big"
  | "line-arrow-cross-default"
  | "line-arrow-cross-small"
  | "line-arrow-down-thick"
  | "line-arrow-down-thin"
  | "line-arrow-left-cross-small"
  | "line-arrow-left-small"
  | "line-arrow-long-down-cross"
  | "line-arrow-long-left-small"
  | "line-arrow-long-left-tiny"
  | "line-arrow-long-right-cross"
  | "line-arrow-long-right-small"
  | "line-arrow-long-right-tiny"
  | "line-arrow-long-right"
  | "line-arrow-right-small"
  | "mail"
  | "map-pin"
  | "quote-filled"
  | "quote"
  | "search"
  | "shape-cone"
  | "shape-cross"
  | "shape-cube"
  | "shape-flower"
  | "shape-globe-open"
  | "shape-globe"
  | "shape-hexogan"
  | "shape-knot"
  | "shape-oval"
  | "shape-sphere"
  | "shape-square-tilt"
  | "shape-square"
  | "shape-star"
  | "target";

export type FontflowOnnatKey =
  | "AngleRight"
  | "CommentsDotsAlt"
  | "CommentsDots"
  | "Cross"
  | "Humburger"
  | "LineArrowCrossBig"
  | "LineArrowCrossDefault"
  | "LineArrowCrossSmall"
  | "LineArrowDownThick"
  | "LineArrowDownThin"
  | "LineArrowLeftCrossSmall"
  | "LineArrowLeftSmall"
  | "LineArrowLongDownCross"
  | "LineArrowLongLeftSmall"
  | "LineArrowLongLeftTiny"
  | "LineArrowLongRightCross"
  | "LineArrowLongRightSmall"
  | "LineArrowLongRightTiny"
  | "LineArrowLongRight"
  | "LineArrowRightSmall"
  | "Mail"
  | "MapPin"
  | "QuoteFilled"
  | "Quote"
  | "Search"
  | "ShapeCone"
  | "ShapeCross"
  | "ShapeCube"
  | "ShapeFlower"
  | "ShapeGlobeOpen"
  | "ShapeGlobe"
  | "ShapeHexogan"
  | "ShapeKnot"
  | "ShapeOval"
  | "ShapeSphere"
  | "ShapeSquareTilt"
  | "ShapeSquare"
  | "ShapeStar"
  | "Target";

export enum FontflowOnnat {
  AngleRight = "angle-right",
  CommentsDotsAlt = "comments-dots-alt",
  CommentsDots = "comments-dots",
  Cross = "cross",
  Humburger = "humburger",
  LineArrowCrossBig = "line-arrow-cross-big",
  LineArrowCrossDefault = "line-arrow-cross-default",
  LineArrowCrossSmall = "line-arrow-cross-small",
  LineArrowDownThick = "line-arrow-down-thick",
  LineArrowDownThin = "line-arrow-down-thin",
  LineArrowLeftCrossSmall = "line-arrow-left-cross-small",
  LineArrowLeftSmall = "line-arrow-left-small",
  LineArrowLongDownCross = "line-arrow-long-down-cross",
  LineArrowLongLeftSmall = "line-arrow-long-left-small",
  LineArrowLongLeftTiny = "line-arrow-long-left-tiny",
  LineArrowLongRightCross = "line-arrow-long-right-cross",
  LineArrowLongRightSmall = "line-arrow-long-right-small",
  LineArrowLongRightTiny = "line-arrow-long-right-tiny",
  LineArrowLongRight = "line-arrow-long-right",
  LineArrowRightSmall = "line-arrow-right-small",
  Mail = "mail",
  MapPin = "map-pin",
  QuoteFilled = "quote-filled",
  Quote = "quote",
  Search = "search",
  ShapeCone = "shape-cone",
  ShapeCross = "shape-cross",
  ShapeCube = "shape-cube",
  ShapeFlower = "shape-flower",
  ShapeGlobeOpen = "shape-globe-open",
  ShapeGlobe = "shape-globe",
  ShapeHexogan = "shape-hexogan",
  ShapeKnot = "shape-knot",
  ShapeOval = "shape-oval",
  ShapeSphere = "shape-sphere",
  ShapeSquareTilt = "shape-square-tilt",
  ShapeSquare = "shape-square",
  ShapeStar = "shape-star",
  Target = "target",
}

export const FONTFLOW_ONNAT_CODEPOINTS: { [key in FontflowOnnat]: string } = {
  [FontflowOnnat.AngleRight]: "61697",
  [FontflowOnnat.CommentsDotsAlt]: "61698",
  [FontflowOnnat.CommentsDots]: "61699",
  [FontflowOnnat.Cross]: "61734",
  [FontflowOnnat.Humburger]: "61735",
  [FontflowOnnat.LineArrowCrossBig]: "61700",
  [FontflowOnnat.LineArrowCrossDefault]: "61701",
  [FontflowOnnat.LineArrowCrossSmall]: "61702",
  [FontflowOnnat.LineArrowDownThick]: "61703",
  [FontflowOnnat.LineArrowDownThin]: "61704",
  [FontflowOnnat.LineArrowLeftCrossSmall]: "61705",
  [FontflowOnnat.LineArrowLeftSmall]: "61706",
  [FontflowOnnat.LineArrowLongDownCross]: "61707",
  [FontflowOnnat.LineArrowLongLeftSmall]: "61708",
  [FontflowOnnat.LineArrowLongLeftTiny]: "61709",
  [FontflowOnnat.LineArrowLongRightCross]: "61710",
  [FontflowOnnat.LineArrowLongRightSmall]: "61711",
  [FontflowOnnat.LineArrowLongRightTiny]: "61712",
  [FontflowOnnat.LineArrowLongRight]: "61713",
  [FontflowOnnat.LineArrowRightSmall]: "61714",
  [FontflowOnnat.Mail]: "61715",
  [FontflowOnnat.MapPin]: "61716",
  [FontflowOnnat.QuoteFilled]: "61717",
  [FontflowOnnat.Quote]: "61718",
  [FontflowOnnat.Search]: "61719",
  [FontflowOnnat.ShapeCone]: "61720",
  [FontflowOnnat.ShapeCross]: "61721",
  [FontflowOnnat.ShapeCube]: "61722",
  [FontflowOnnat.ShapeFlower]: "61723",
  [FontflowOnnat.ShapeGlobeOpen]: "61724",
  [FontflowOnnat.ShapeGlobe]: "61725",
  [FontflowOnnat.ShapeHexogan]: "61726",
  [FontflowOnnat.ShapeKnot]: "61727",
  [FontflowOnnat.ShapeOval]: "61728",
  [FontflowOnnat.ShapeSphere]: "61729",
  [FontflowOnnat.ShapeSquareTilt]: "61730",
  [FontflowOnnat.ShapeSquare]: "61731",
  [FontflowOnnat.ShapeStar]: "61732",
  [FontflowOnnat.Target]: "61733",
};
