<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Header' ) ) {

	/**
	 * Define the header custom post type.
	 */
    class KinForce_Extra_Plugin_CPT_Header {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'init', [ $this, 'init' ] );
            add_action( 'admin_menu', [ $this, 'admin_menu' ] );
            add_filter( 'parent_file', [ $this, 'admin_parent_file' ] );

            add_filter( 'single_template', [ $this, 'load_template' ] );

        }

        public function init() {

            $labels = [
                'name'               => __( 'Headers', 'onnat-extra' ),
                'singular_name'      => __( 'Header', 'onnat-extra' ),
                'menu_name'          => __( 'Header', 'onnat-extra' ),
                'name_admin_bar'     => __( 'Header', 'onnat-extra' ),
                'add_new'            => __( 'Add New', 'onnat-extra' ),
                'add_new_item'       => __( 'Add New Header', 'onnat-extra' ),
                'new_item'           => __( 'New Template', 'onnat-extra' ),
                'edit_item'          => __( 'Edit Template', 'onnat-extra' ),
                'view_item'          => __( 'View Template', 'onnat-extra' ),
                'all_items'          => __( 'Header', 'onnat-extra' ),
                'search_items'       => __( 'Search Templates', 'onnat-extra' ),
                'parent_item_colon'  => __( 'Parent Templates:', 'onnat-extra' ),
                'not_found'          => __( 'No Templates found.', 'onnat-extra' ),
                'not_found_in_trash' => __( 'No Templates found in Trash.', 'onnat-extra' ),
            ];

            $args   = [
                'label'               => esc_html__( 'Header', 'onnat-extra' ),
                'labels'              => $labels,
                'supports'            => array( 'title', 'editor' ),
                'hierarchical'        => true,
                'public'              => true,
                'show_ui'             => true,
                'show_in_admin_bar'   => true,
                'show_in_menu'        => 'false',
                'show_in_nav_menus'   => false,
                'can_export'          => false,
                'has_archive'         => false,
                'exclude_from_search' => true,
                'publicly_queryable'  => true,
                'capability_type'     => 'page',
                'show_in_rest'        => true
            ];

            register_post_type( 'kinfw-header', $args );
        }

        public function admin_menu() {

            if( !current_user_can('edit_pages') ) {

                return;
            }

            add_submenu_page(
                ONNAT_CONST_SAN_THEME,
                esc_html__( 'Headers', 'onnat-extra' ),
                esc_html__( 'Headers', 'onnat-extra' ),
                'edit_pages',
                'edit.php?post_type=kinfw-header',
                '',
                30
            );

        }

        public function admin_parent_file( $parent_file ) {

            global $submenu_file, $current_screen;

            if( $current_screen->post_type == "kinfw-header" ) {

                $parent_file  = ONNAT_CONST_SAN_THEME;
                $submenu_file = 'edit.php?post_type=kinfw-header';

            }

            return $parent_file;

        }

        public function load_template( $template ) {

            global $post;
            $type = $post->post_type;

            if ( 'kinfw-header' === $type ) {

                $template = KFE_CONST_DIR . 'libraries/framework/single/single-kinfw-header.php';

            }

            return $template;
        }

    }
}

if( !function_exists( 'kf_extra_plugin_cpt_header' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_header() {

        return KinForce_Extra_Plugin_CPT_Header::get_instance();
    }
}

kf_extra_plugin_cpt_header();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */