<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_CPT_Mega_Menu' ) ) {

	/**
	 * Define the header custom post type.
	 */
    class KinForce_Extra_Plugin_CPT_Mega_Menu {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'init', [ $this, 'init' ] );
        }

        public function init() {

            $labels = [
                'name'               => __( 'Mega Menus', 'onnat-extra' ),
                'singular_name'      => __( 'Mega Menu', 'onnat-extra' ),
                'menu_name'          => __( 'Mega Menu', 'onnat-extra' ),
                'name_admin_bar'     => __( 'Mega Menu', 'onnat-extra' ),
                'add_new'            => __( 'Add New', 'onnat-extra' ),
                'add_new_item'       => __( 'Add New Mega Menu', 'onnat-extra' ),
                'new_item'           => __( 'New Template', 'onnat-extra' ),
                'edit_item'          => __( 'Edit Template', 'onnat-extra' ),
                'view_item'          => __( 'View Template', 'onnat-extra' ),
                'all_items'          => __( 'Mega Menu', 'onnat-extra' ),
                'search_items'       => __( 'Search Templates', 'onnat-extra' ),
                'parent_item_colon'  => __( 'Parent Templates:', 'onnat-extra' ),
                'not_found'          => __( 'No Templates found.', 'onnat-extra' ),
                'not_found_in_trash' => __( 'No Templates found in Trash.', 'onnat-extra' ),
            ];

            $args   = [
                'label'               => esc_html__( 'Mega Menu', 'onnat-extra' ),
                'labels'              => $labels,
                'supports'            => array( 'title', 'editor', 'elementor', 'permalink' ),
                'hierarchical'        => true,
                'public'              => true,
                'show_ui'             => false,
                'show_in_admin_bar'   => false,
                'show_in_menu'        => true,
                'show_in_nav_menus'   => false,
                'show_in_graphql'     => false,
                'delete_with_user'    => false,
                'can_export'          => false,
                'has_archive'         => false,
                'exclude_from_search' => true,
                "map_meta_cap"        => true,
                'publicly_queryable'  => true,
                'capability_type'     => 'page',
                "query_var"           => true,
                'show_in_rest'        => true
            ];

            register_post_type( 'kinfw-mega-menu', $args );
        }

    }
}

if( !function_exists( 'kf_extra_plugin_cpt_mega' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_cpt_mega() {

        return KinForce_Extra_Plugin_CPT_Mega_Menu::get_instance();
    }
}

kf_extra_plugin_cpt_mega();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */