var $         = jQuery.noConflict(),
    KF_FW_OBJ = KF_FW_OBJ || {};

(function($){
    "use strict";

    KF_FW_OBJ.NavMenuPage =  {
        init: function() {
            KF_FW_OBJ.NavMenuPage.openMegaMenuModal();
            KF_FW_OBJ.NavMenuPage.closeMegaMenuModal();
            KF_FW_OBJ.NavMenuPage.saveMegaMenuSaveModal();
            KF_FW_OBJ.NavMenuPage.cancelMegaMenuSaveModal();
            KF_FW_OBJ.NavMenuPage.closeMegaMenuSaveModal();
        },

        openMegaMenuModal: function() {
            $("#menu-to-edit").on("click", ".kinfw-mega-menu-trigger", function(e){
                e.preventDefault();

                var $menu_item    = $(this).parents("li.menu-item"),
                    $menu_item_id = parseInt($menu_item.attr("id").match(/[0-9]+/)[0], 10);

                $.ajax({
                    url    : ajaxurl,
                    type   : 'post',
                    data   : {
                        action: 'kinfw-action/theme/nav-menu/mega-menu/editor/load',
                        _id   : $menu_item_id,
                    },
                    success: function (res) {
                        $("#kinfw-mega-menu-modal").find("#kinfw-megamenu-iframe").empty();

                        if( res.success) {
                            $("#kinfw-mega-menu-modal").find("#kinfw-megamenu-iframe").attr("src",res.data.post_url);
                            setTimeout(function(){
                                $("#kinfw-mega-menu-modal").show("fast",function(){
                                    $(this).addClass("kinfw-model-open");
                                });
                            }, 400 );
                        }
                    },
                });
            });
        },

        closeMegaMenuModal: function() {
            $("#kinfw-mega-menu-modal").on("click", ".kinfw-modal-close-button", function(e){
                e.preventDefault();

                var $iframe                = document.getElementById("kinfw-megamenu-iframe"),
                    $iframe_content        = ($iframe.contentWindow || $iframe.contentDocument),
                    $elementor_save_button = $iframe_content.jQuery('#elementor-panel-saver-button-publish');

                if( !$elementor_save_button.hasClass("elementor-disabled") ) {
                    $("#kinfw-mega-menu-save-modal").show("fast",function(){
                        $(this).addClass("kinfw-model-open");
                    });
                } else {
                    $("#kinfw-mega-menu-modal").hide("fast",function(){
                        $(this).removeClass("kinfw-model-open");
                    });

                    $("#kinfw-mega-menu-save-modal").hide("fast",function(){
                        $(this).removeClass("kinfw-model-open");
                    });
                }
            });
        },

        saveMegaMenuSaveModal: function() {
            $("#kinfw-mega-menu-save-modal").on("click", "#kinfw-save", function(e){
                var $iframe         = document.getElementById("kinfw-megamenu-iframe"),
                    $iframe_content = ($iframe.contentWindow || $iframe.contentDocument);

                $iframe_content.jQuery('#elementor-panel-saver-button-publish').trigger('click');
                $iframe_content.jQuery($iframe_content).off('beforeunload');

                setTimeout(function(){
                    $("#kinfw-mega-menu-save-modal").hide("fast",function(){
                        $(this).removeClass("kinfw-model-open");
                    });

                    $("#kinfw-mega-menu-modal").hide("fast",function(){
                        $(this).removeClass("kinfw-model-open");
                    });
                }, 400 );
            });
        },

        cancelMegaMenuSaveModal: function() {
            $("#kinfw-mega-menu-save-modal").on("click", "#kinfw-cancel", function(e){

                var $iframe         = document.getElementById("kinfw-megamenu-iframe"),
                    $iframe_content = ($iframe.contentWindow || $iframe.contentDocument);

                $iframe_content.jQuery($iframe_content).off('beforeunload');

                setTimeout(function(){
                    $("#kinfw-mega-menu-save-modal").hide("fast",function(){
                        $(this).removeClass("kinfw-model-open");
                    });

                    $("#kinfw-mega-menu-modal").hide("fast",function(){
                        $(this).removeClass("kinfw-model-open");
                    });
                }, 400 );

            });
        },

        closeMegaMenuSaveModal: function() {
            $("#kinfw-mega-menu-save-modal").on("click", ".kinfw-modal-close-button", function(e){
                e.preventDefault();

                $("#kinfw-mega-menu-save-modal").hide("fast",function(){
                    $(this).removeClass("kinfw-model-open");
                });
            });
        },
    };

    KF_FW_OBJ.documentOnReady = {
        init: function() {
            KF_FW_OBJ.NavMenuPage.init();
        }
    };

    var $window = $(window),
        $body   = $("body");

    $(document).ready( KF_FW_OBJ.documentOnReady.init );
})(jQuery);