<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_RB4T' ) ) {

    class KinForce_RB4T {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

        public $taxonomies = [];

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

			$this->load();

            $this->taxonomies = apply_filters( 'kinfw-filter/plugin/radio-buttons-for-taxonomies', [] );

            add_action( 'wp_loaded', [ $this, 'launch' ] );

            // Load admin scripts.
            add_action( 'admin_enqueue_scripts', [ $this, 'admin_script' ] );
        }

		public function load() {
			require_once KFE_CONST_DIR . 'libraries/radio-buttons-for-taxonomies/class-wp-radio-taxonomy.php';
			require_once KFE_CONST_DIR . 'libraries/radio-buttons-for-taxonomies/class-wp-walker-radio-taxonomy.php';
        }

        public function launch() {

            /**
             * Use this filter to add taxonomy to change it to radio button
             */
            $taxonomies = $this->taxonomies;

            foreach( $taxonomies as $taxonomy ) {
                if( taxonomy_exists( $taxonomy ) ) {
                    new KinForce_WP_Radio_Taxonomy( $taxonomy );
                }
            }
        }

        public function admin_script() {
            $screen           = get_current_screen();
            $screen_base      = $screen ? $screen->base : '';
            $post_type        = $screen ? $screen->post_type : '';
            $has_block_editor = is_callable( array( $screen, 'is_block_editor' ) ) && $screen->is_block_editor();

            if ( in_array( $screen_base, array( 'post', 'edit' ) ) && ! $has_block_editor ) {
                $taxonomies = $this->taxonomies;

    			// If the post type has a radio taxonomy.
                if ( $post_type && array_intersect( $taxonomies, get_object_taxonomies( $post_type, 'names' ) ) ) {

                    wp_register_script( 'kfw-radiotax',
                        KFE_CONST_URL . 'libraries/radio-buttons-for-taxonomies/assets/js/radio-taxonomies' . KFE_CONST_DEBUG_SUFFIX . '.js',
                        [ 'jquery', 'inline-edit-post' ],
                        KFE_CONST_VERSION,
                        true
                    );

                    wp_enqueue_script( 'kfw-radiotax' );
                }
            }
        }

        public function block_editor_assets() {}

    }

}

if( !function_exists( 'kf_extra_plugin_rb4t' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_rb4t() {

        return KinForce_RB4T::get_instance();
    }
}

kf_extra_plugin_rb4t();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */