<?php
class KinForce_Walker_Category_Radio extends Walker {

	private $printed_nonce = false;

	public  $tree_type     = 'category';
	public  $db_fields     = [
		'parent' => 'parent',
		'id'     => 'term_id',
    ];

	public function start_lvl( &$output, $depth = 0, $args = [] ) {
		$indent  = str_repeat( "\t", $depth );
		$output .= "$indent<ul class='children'>\n";
	}

	public function end_lvl( &$output, $depth = 0, $args = [] ) {
		$indent  = str_repeat( "\t", $depth );
		$output .= "$indent</ul>\n";
	}

	public function end_el( &$output, $data_object, $depth = 0, $args = [] ) {
		$output .= "</li>\n";
	}

    public function start_el( &$output, $data_object, $depth = 0, $args = [], $current_object_id = 0 ) {
        $category = $data_object;

		if ( empty( $args['taxonomy'] ) ) {
			$taxonomy = 'category';
		} else {
			$taxonomy = $args['taxonomy'];
		}

		// Force add nonce field, which is otherwise impossible in quick/bulk edit.
		if ( ! $this->printed_nonce ) {
			$output .= wp_nonce_field( 'radio_nonce-' . $taxonomy, '_radio_nonce-' . $taxonomy, true, false );
			$this->printed_nonce = true;
		}

        $name = 'radio_tax_input['.$taxonomy.']';

        $args['popular_cats'] = ! empty( $args['popular_cats'] ) ? array_map( 'intval', $args['popular_cats'] ) : [];

		$class = in_array( $category->term_id, $args['popular_cats'], true ) ? ' class="popular-category"' : '';

		$args['selected_cats'] = ! empty( $args['selected_cats'] ) ? array_map( 'intval', $args['selected_cats'] ) : [];

        $selected_term = ! empty( $args['selected_cats'] ) && ! is_wp_error( $args['selected_cats'] ) ? array_pop( $args['selected_cats'] ) : false;
        $selected_id   = ( $selected_term ) ? $selected_term : intval( get_option( 'default_' . $taxonomy, 0 ) );

        if ( ! empty( $args['list_only'] ) ) {
			$aria_checked = 'false';
			$inner_class  = 'category';

			if ( in_array( $category->term_id, $args['selected_cats'], true ) ) {
				$inner_class .= ' selected';
				$aria_checked = 'true';
			}

			$output .= "\n" . '<li' . $class . '>' .
				'<div class="' . esc_attr( $inner_class ) . '" data-term-id=' . intval( $category->term_id ) .
				' tabindex="0" role="radio" aria-checked="' . esc_attr( $aria_checked ) . '">' .
				/** This filter is documented in wp-includes/category-template.php */
				esc_html( apply_filters( 'the_category', $category->name, '', '' ) ) . '</div>';
        } else {
            $output .= "\n<li id='{$taxonomy}-{$category->term_id}'$class>" .
                '<label class="selectit">
                    <input
                        type="radio"
                        value="' . intval( $category->term_id ) . '"
                        name="'.esc_attr( $name ).'[]"
                        id="in-'.esc_attr( $taxonomy ).'-' . intval( $category->term_id ) . '"' .
                        checked( $category->term_id, $selected_id, false ) .
                        disabled( empty( $args['disabled'] ), false, false ) . ' /> ' .
                    esc_html( apply_filters( 'the_category', $category->name ) ) .
                '</label>';
        }
    }
}