<?php

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'KinForce_Extra_Plugin_Shortcodes' ) ) {

	/**
	 * Define the elementor plugin compatibility.
	 */
    class KinForce_Extra_Plugin_Shortcodes {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

			add_shortcode( 'kfw_current_year', [ $this, 'show_current_year' ] );

        }

		function show_current_year() {

			$current_year = do_shortcode( shortcode_unautop( gmdate( 'Y' ) ) );

			if( !empty( $current_year ) ) {

				return $current_year;
			}
		}
    }

}

if( !function_exists( 'kf_extra_plugin_shortcodes' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kf_extra_plugin_shortcodes() {

        return KinForce_Extra_Plugin_Shortcodes::get_instance();
    }
}

kf_extra_plugin_shortcodes();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */