<?php
/**
 * Theme Demo Content integration.
 *
 */
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

if( !class_exists( 'Onnat_Theme_Demo' ) ) {

	/**
	 * The Onnat theme demo content setup class.
	 */
    class Onnat_Theme_Demo {

		/**
		 * A reference to an instance of this class.
		 */
		private static $instance = null;

		/**
		 * Returns the instance.
		 */
		public static function get_instance() {

			// If the single instance hasn't been set, set it now.
			if ( null == self::$instance ) {
				self::$instance = new self;
            }

			return self::$instance;

		}

		/**
		 * Constructor
		 */
        public function __construct() {

            add_action( 'after_setup_theme', [ $this, 'add_theme_supports' ] );
            add_filter( 'fw_ext_backups_demo_dirs', [ $this, 'demo_dir' ] );
            add_filter( 'kinfw-filter/theme/admin-screen/menu', [ $this, 'admin_menus' ], 999 );
        }

        public function add_theme_supports() {
            $option                 = get_option( 'fw_active_extensions', [] );
            $option['backups']      = [];
            $option['backups-demo'] = [];

            update_option('fw_active_extensions', $option);
        }

        public function demo_dir() {
            return [
                fw_fix_path( get_stylesheet_directory() ) . '/demo-content' => get_stylesheet_directory_uri() .'/demo-content',
            ];
        }

        public function admin_menus( $menus ) {
            if( function_exists( 'kf_onnat_extra_plugin' ) ) {
                $menus[41] = [
                    'id'    => '',
                    'title' => esc_html__( 'Demo Content', 'onnat-demo-child' ),
                    'href'  => admin_url( add_query_arg( 'page', 'fw-backups-demo-content', 'tools.php' ) ),
                ];
            }

            return $menus;
        }
    }

}

if( !function_exists( 'kinfw_onnat_theme_demo' ) ) {

    /**
     * Returns the instance of a class.
     */
    function kinfw_onnat_theme_demo() {

        return Onnat_Theme_Demo::get_instance();
    }
}

kinfw_onnat_theme_demo();
/* Omit closing PHP tag to avoid "Headers already sent" issues. */