<?php
require 'stripe/init.php';

\Stripe\Stripe::setApiKey('sk_test_IaJkqUaK8mzjfqh0WFARG9pp'); // Replace with real secret key

header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);

try {
    // 1. Create a customer
    $customer = \Stripe\Customer::create([
        'name' => $data['name'],
        'email' => $data['email'],
        'phone' => $data['phone'],
        'address' => [
            'line1' => $data['address']['line1'],
            'city' => $data['address']['city'],
            'state' => $data['address']['state'],
            'postal_code' => $data['address']['postal_code'],
            'country' => $data['address']['country']
        ]
    ]);

    // 2. Create PaymentIntent (uncaptured)
    $intent = \Stripe\PaymentIntent::create([
        'amount' => $data['amount'],
        'currency' => 'gbp',
        'customer' => $customer->id,
        'capture_method' => 'manual',
        'automatic_payment_methods' => ['enabled' => true],
    ]);

    echo json_encode(['client_secret' => $intent->client_secret]);
} catch (\Stripe\Exception\ApiErrorException $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
