<?php
add_action('wp_ajax_ssb_charge_customer', 'ssb_charge_customer');
function ssb_charge_customer() {
    \Stripe\Stripe::setApiKey(SSB_STRIPE_SECRET_KEY);

    $data = json_decode(file_get_contents('php://input'), true);
    $amount = intval($data['amount']) * 100;

    try {
        \Stripe\PaymentIntent::create([
            'amount' => $amount,
            'currency' => 'usd',
            'customer' => $data['customer_id'],
            'payment_method' => $data['payment_method'],
            'off_session' => true,
            'confirm' => true,
        ]);
        echo json_encode(['status' => 'success', 'message' => 'Charged successfully.']);
    } catch (\Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }
    wp_die();
}
add_action('wp_ajax_ssb_subscribe_customer', 'ssb_subscribe_customer');
function ssb_subscribe_customer() {
    \Stripe\Stripe::setApiKey(SSB_STRIPE_SECRET_KEY);

    $data = json_decode(file_get_contents('php://input'), true);

    try {
        // Create product
        $product = \Stripe\Product::create([
            'name' => 'Custom Subscription for ' . $data['customer_id'],
        ]);

        // Create price
        $price = \Stripe\Price::create([
            'unit_amount' => intval($data['amount']) * 100,
            'currency' => 'usd',
            'recurring' => ['interval' => $data['interval']],
            'product' => $product->id,
        ]);

        // Parse dates
        $start_timestamp = strtotime($data['start_date']);
        $cancel_timestamp = strtotime("+{$data['months']} months", $start_timestamp);

        // Create subscription with trial until start_date
        \Stripe\Subscription::create([
            'customer' => $data['customer_id'],
            'items' => [[ 'price' => $price->id ]],
            'default_payment_method' => $data['payment_method'],
            'trial_end' => $start_timestamp,
            'cancel_at' => $cancel_timestamp,
        ]);

        echo json_encode(['status' => 'success', 'message' => 'Subscription created with start and end date!']);
    } catch (\Exception $e) {
        echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
    }

    wp_die();
}


// add_action('wp_ajax_ssb_subscribe_customer', 'ssb_subscribe_customer');
// function ssb_subscribe_customer() {
//     \Stripe\Stripe::setApiKey(SSB_STRIPE_SECRET_KEY); // Replace with yours

//     $data = json_decode(file_get_contents('php://input'), true);

//     try {
//         // Create a product
//         $product = \Stripe\Product::create([
//             'name' => 'Custom Subscription for ' . $data['customer_id'],
//         ]);

//         // Create a price
//         $price = \Stripe\Price::create([
//             'unit_amount' => intval($data['amount']) * 100,
//             'currency' => 'usd',
//             'recurring' => [
//                 'interval' => $data['interval'], // 'month' or 'week'
//             ],
//             'product' => $product->id,
//         ]);

//         // Create the subscription
//         \Stripe\Subscription::create([
//             'customer' => $data['customer_id'],
//             'items' => [[ 'price' => $price->id ]],
//             'default_payment_method' => $data['payment_method'],
//         ]);

//         echo json_encode(['status' => 'success', 'message' => 'Subscription created successfully!']);
//     } catch (\Exception $e) {
//         echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
//     }

//     wp_die();
// }

