<?php
function ssb_card_form_shortcode() {
    ob_start(); ?>
    <style>
      .ssb-container {
        max-width: 500px;
        margin: 40px auto;
        padding: 30px;
        background-color: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.05);
        font-family: 'Helvetica Neue', sans-serif;
        background: #fff8f9;
      }

      .ssb-container h2 {
        color: #d99ba8;
        font-weight: bold;
        text-align: center;
        margin-bottom: 20px;
      }

      .ssb-container input,
      .StripeElement {
        border-radius: 10px;
        border: 1px solid #ddd;
        padding: 10px 15px;
        width: 94%;
      }

      .ssb-container button {
        background-color: #d99ba8;
        color: white;
        border: none;
        font-weight: bold;
        border-radius: 10px;
        height: 45px;
        width: 100%;
      }

      .ssb-container button:hover {
        background-color: #c58695;
      }

      .ssb-container .alert {
        border-radius: 10px;
      }

      .ssb-container #ssb-card-element {
       
        border-radius: 10px;
        border: 1px solid #ddd;
        background: white;
      }
      .mb-3{
       margin-bottom:5px;   
      }
      .mt-3{
          margin-top:5px;
      }
    </style>

    <div class="ssb-container">
      <h2>Secure Your Payment</h2>
      <form id="ssb-card-form">
        <div class="mb-3">
          <input type="text" id="ssb_name" class="form-control" placeholder="Full Name" required>
        </div>
        <div class="mb-3">
          <input type="email" id="ssb_email" class="form-control" placeholder="Email Address" required>
        </div>
        <div class="mb-3">
          <div id="ssb-card-element"></div>
        </div>
        <div id="ssb-card-errors" class="text-danger mb-3"></div>
        <button type="submit" class="btn w-100">Save Card</button>
        <div id="ssb-success-message" class="alert alert-success mt-3 d-none"></div>
      </form>
    </div>

    <script src="https://js.stripe.com/v3/"></script>
    <script>
      document.addEventListener("DOMContentLoaded", async () => {
        const stripe = Stripe("<?= SSB_STRIPE_PUBLISHABLE_KEY ?>");
        const elements = stripe.elements();
        const card = elements.create("card");
        card.mount("#ssb-card-element");

        document.getElementById("ssb-card-form").addEventListener("submit", async (e) => {
          e.preventDefault();
          const name = document.getElementById("ssb_name").value;
          const email = document.getElementById("ssb_email").value;

          const response = await fetch("<?php echo admin_url('admin-ajax.php'); ?>?action=ssb_create_setup_intent", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ name, email })
          });

          const data = await response.json();

          const { setupIntent, error } = await stripe.confirmCardSetup(data.client_secret, {
            payment_method: {
              card: card,
              billing_details: { name, email },
            },
          });

          if (error) {
            document.getElementById("ssb-card-errors").textContent = error.message;
          } else {
            const msg = document.getElementById("ssb-success-message");
            msg.classList.remove("d-none");
            msg.innerHTML = "Card saved successfully!"

            // Save to WordPress DB
            fetch("<?php echo admin_url('admin-ajax.php'); ?>?action=ssb_save_payment_data", {
              method: "POST",
              headers: { "Content-Type": "application/json" },
              body: JSON.stringify({
                name,
                email,
                customer_id: data.customer_id,
                payment_method_id: setupIntent.payment_method
              })
            });
          }
        });
      });
    </script>
    <?php return ob_get_clean();
}
add_shortcode('stripe_card_form', 'ssb_card_form_shortcode');
